/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.mp.datascope;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.mp.datascope.config.DataScopeConfig;
import cn.stylefeng.roses.kernel.db.mp.datascope.holder.DataScopeHolder;
import com.baomidou.mybatisplus.extension.plugins.handler.MultiDataPermissionHandler;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;

public class ProjectDataScopeHandler
implements MultiDataPermissionHandler {
    public static final Long NONE_ID_VALUE = -1L;
    public static final String DEFAULT_USER_ID_FIELD_NAME = "user_id";
    public static final String DEFAULT_ORG_ID_FIELD_NAME = "org_id";

    public Expression getSqlSegment(Table table, Expression where, String mappedStatementId) {
        DataScopeConfig dataScopeConfig = DataScopeHolder.get();
        if (ObjectUtil.isEmpty((Object)dataScopeConfig)) {
            return null;
        }
        if (dataScopeConfig.isTotalDataScope()) {
            return null;
        }
        Object dataScopeExpression = null;
        if (dataScopeConfig.isDoCreateUserValidate()) {
            Long currentUserId = dataScopeConfig.getUserId();
            dataScopeExpression = ProjectDataScopeHandler.getEqualsTo(dataScopeConfig.getUserIdFieldName(), currentUserId);
        }
        if (dataScopeConfig.isDoOrgScopeValidate()) {
            InExpression orgScopeCondition = ProjectDataScopeHandler.getInExpression(dataScopeConfig);
            dataScopeExpression = dataScopeExpression != null ? new AndExpression((Expression)dataScopeExpression, (Expression)orgScopeCondition) : orgScopeCondition;
        }
        return dataScopeExpression;
    }

    private static EqualsTo getEqualsTo(String fieldName, Long value) {
        Column orgIdColumn = new Column(fieldName);
        LongValue longValue = new LongValue(value.longValue());
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)orgIdColumn);
        equalsTo.setRightExpression((Expression)longValue);
        return equalsTo;
    }

    private static InExpression getInExpression(DataScopeConfig dataScopeConfig) {
        Column orgIdColumn = new Column(dataScopeConfig.getOrgIdFieldName());
        ExpressionList expressionList = new ExpressionList(new Expression[0]);
        expressionList.setExpressions(dataScopeConfig.getUserOrgIdList().stream().map(LongValue::new).collect(Collectors.toList()));
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)orgIdColumn);
        inExpression.setRightExpression((Expression)new Parenthesis((Expression)expressionList));
        return inExpression;
    }
}

