/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.mp.tenant.defaultimpl;

import cn.stylefeng.roses.kernel.db.mp.tenant.SaasServiceApi;
import cn.stylefeng.roses.kernel.db.mp.tenant.TenantSwitchApi;
import cn.stylefeng.roses.kernel.db.mp.tenant.holder.TenantIdHolder;
import cn.stylefeng.roses.kernel.db.mp.tenant.holder.TenantSwitchHolder;
import cn.stylefeng.roses.kernel.db.mp.tenant.pojo.TenantSwitchInfo;
import jakarta.annotation.Resource;
import java.util.function.Supplier;

public class DefaultTenantSwitchImpl
implements TenantSwitchApi {
    @Resource
    private SaasServiceApi saasServiceApi;

    @Override
    public <T> T changeTenant(String tenantCode, Supplier<T> action) {
        TenantSwitchInfo tenantSwitchInfo = this.saasServiceApi.getTenantSwitchInfo(tenantCode);
        if (tenantSwitchInfo == null) {
            return action.get();
        }
        return this.commonChangeTenant(action, tenantSwitchInfo);
    }

    @Override
    public <T> T changeTenant(Long tenantId, Supplier<T> action) {
        TenantSwitchInfo tenantSwitchInfo = this.saasServiceApi.getTenantSwitchInfo(tenantId);
        if (tenantSwitchInfo == null) {
            return action.get();
        }
        return this.commonChangeTenant(action, tenantSwitchInfo);
    }

    @Override
    public <T> T changeTenant(TenantSwitchInfo tenantSwitchInfo, Supplier<T> action) {
        return this.commonChangeTenant(action, tenantSwitchInfo);
    }

    @Override
    public <T> T doNoTenantChange(Supplier<T> action) {
        try {
            TenantSwitchHolder.set(false);
            T t = action.get();
            return t;
        }
        finally {
            TenantSwitchHolder.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T commonChangeTenant(Supplier<T> action, TenantSwitchInfo tenantSwitchInfo) {
        Long currentTenantId = TenantIdHolder.get();
        try {
            TenantIdHolder.set(tenantSwitchInfo.getTenantId());
            T t = action.get();
            return t;
        }
        finally {
            TenantIdHolder.set(currentTenantId);
        }
    }
}

