/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.dsctn.modular.timer;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.dsctn.api.enums.DataSourceStatusEnum;
import cn.stylefeng.roses.kernel.dsctn.api.pojo.request.DatabaseInfoRequest;
import cn.stylefeng.roses.kernel.dsctn.modular.entity.DatabaseInfo;
import cn.stylefeng.roses.kernel.dsctn.modular.service.DatabaseInfoService;
import cn.stylefeng.roses.kernel.timer.api.TimerAction;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DataSourceStatusCheckTimer
implements TimerAction {
    @Resource
    private DatabaseInfoService databaseInfoService;

    public void action(String params) {
        List list = this.databaseInfoService.list();
        if (ObjectUtil.isEmpty((Object)list)) {
            return;
        }
        for (DatabaseInfo databaseInfo : list) {
            DatabaseInfoRequest databaseInfoRequest = new DatabaseInfoRequest();
            databaseInfoRequest.setJdbcDriver(databaseInfo.getJdbcDriver());
            databaseInfoRequest.setJdbcUrl(databaseInfo.getJdbcUrl());
            databaseInfoRequest.setUsername(databaseInfo.getUsername());
            databaseInfoRequest.setPassword(databaseInfo.getPassword());
            try {
                this.databaseInfoService.validateConnection(databaseInfoRequest);
            }
            catch (Exception exception) {
                String errorMessage = exception.getMessage();
                if (DataSourceStatusEnum.ERROR.getCode().equals(databaseInfo.getStatusFlag())) continue;
                databaseInfo.setStatusFlag(DataSourceStatusEnum.ERROR.getCode());
                databaseInfo.setErrorDescription(errorMessage);
                this.databaseInfoService.updateById((Object)databaseInfo);
                continue;
            }
            if (DataSourceStatusEnum.ENABLE.getCode().equals(databaseInfo.getStatusFlag())) continue;
            databaseInfo.setStatusFlag(DataSourceStatusEnum.ENABLE.getCode());
            this.databaseInfoService.updateById((Object)databaseInfo);
        }
    }
}

