/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.event.sdk;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.event.api.annotation.BusinessListener;
import cn.stylefeng.roses.kernel.event.sdk.container.EventContainer;
import cn.stylefeng.roses.kernel.event.sdk.pojo.BusinessListenerDetail;
import cn.stylefeng.roses.kernel.rule.util.AopTargetUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class EventAnnotationScanner
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventAnnotationScanner.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object aopTarget = AopTargetUtils.getTarget((Object)bean);
        if (aopTarget == null) {
            aopTarget = bean;
        }
        Class<?> clazz = aopTarget.getClass();
        this.doScan(clazz, beanName);
        return bean;
    }

    private void doScan(Class<?> clazz, String beanName) {
        Method[] declaredMethods;
        for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
            BusinessListener businessListener = declaredMethod.getAnnotation(BusinessListener.class);
            log.debug("\u626b\u63cf\u5230\u4e1a\u52a1\u4e8b\u4ef6\u76d1\u542c: " + businessListener);
            if (businessListener == null) continue;
            this.createEventDetail(beanName, declaredMethod, businessListener);
        }
    }

    private void createEventDetail(String beanName, Method method, BusinessListener businessListener) {
        String businessCode = businessListener.businessCode();
        List<BusinessListenerDetail> listener = EventContainer.getListener(businessCode);
        if (ObjectUtil.isEmpty(listener)) {
            listener = new ArrayList<BusinessListenerDetail>();
        }
        BusinessListenerDetail businessListenerDetail = new BusinessListenerDetail();
        businessListenerDetail.setBeanName(beanName);
        businessListenerDetail.setListenerMethod(method);
        int parameterCount = method.getParameterCount();
        if (parameterCount == 0) {
            businessListenerDetail.setParameterClassType(null);
        } else {
            businessListenerDetail.setParameterClassType(method.getParameterTypes()[0]);
        }
        listener.add(businessListenerDetail);
        EventContainer.addListenerList(businessCode, listener);
    }
}

