/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.event.sdk.publish;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.event.api.exception.enums.EventExceptionEnum;
import cn.stylefeng.roses.kernel.event.sdk.container.EventContainer;
import cn.stylefeng.roses.kernel.event.sdk.pojo.BusinessListenerDetail;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessEventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessEventPublisher.class);

    public static <T> void publishEvent(String businessCode, T businessObject) {
        List<BusinessListenerDetail> listener = EventContainer.getListener(businessCode);
        if (ObjectUtil.isEmpty(listener)) {
            return;
        }
        for (BusinessListenerDetail businessListenerDetail : listener) {
            String beanName = businessListenerDetail.getBeanName();
            Object bean = SpringUtil.getBean((String)beanName);
            Method listenerMethod = businessListenerDetail.getListenerMethod();
            Class<?> parameterClassType = businessListenerDetail.getParameterClassType();
            if (ObjectUtil.isEmpty(businessObject)) {
                if (parameterClassType != null) continue;
                try {
                    listenerMethod.invoke(bean, new Object[0]);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u53cd\u5c04\u8c03\u7528\u5f02\u5e38", (Throwable)e);
                    throw new ServiceException((AbstractExceptionEnum)EventExceptionEnum.ERROR_INVOKE);
                }
            }
            if (parameterClassType == null || !parameterClassType.equals(businessObject.getClass()) && !parameterClassType.isAssignableFrom(businessObject.getClass())) continue;
            try {
                listenerMethod.invoke(bean, businessObject);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff0c\u53cd\u5c04\u8c03\u7528\u5f02\u5e38", (Throwable)e);
                throw new ServiceException((AbstractExceptionEnum)EventExceptionEnum.ERROR_INVOKE);
            }
        }
    }
}

