/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.modular.factory;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.enums.FileLocationEnum;
import cn.stylefeng.roses.kernel.file.api.enums.FileStatusEnum;
import cn.stylefeng.roses.kernel.file.api.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.api.pojo.request.SysFileInfoRequest;
import cn.stylefeng.roses.kernel.file.modular.entity.SysFileInfo;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class FileInfoFactory {
    public static Map<MultipartFile, SysFileInfo> batchCreateFileInfo(MultipartFile[] fileList, SysFileInfoRequest sysFileInfoRequest) {
        HashMap<MultipartFile, SysFileInfo> result = new HashMap<MultipartFile, SysFileInfo>();
        for (MultipartFile multipartFile : fileList) {
            result.put(multipartFile, FileInfoFactory.createSysFileInfo(multipartFile, sysFileInfoRequest));
        }
        return result;
    }

    public static SysFileInfo createSysFileInfo(MultipartFile file, SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfo sysFileInfo = new SysFileInfo();
        FileInfoFactory.fillCommonInfo(sysFileInfo, sysFileInfoRequest);
        String originalFilename = file.getOriginalFilename();
        sysFileInfo.setFileOriginName(originalFilename);
        String fileSuffix = null;
        if (ObjectUtil.isNotEmpty((Object)originalFilename)) {
            fileSuffix = StrUtil.subAfter((CharSequence)originalFilename, (CharSequence)".", (boolean)true);
        }
        sysFileInfo.setFileSuffix(fileSuffix);
        long fileSizeKb = Convert.toLong((Object)NumberUtil.div((Number)new BigDecimal(file.getSize()), (Number)BigDecimal.valueOf(1024L)).setScale(0, 4));
        sysFileInfo.setFileSizeKb(fileSizeKb);
        String fileSizeInfo = FileUtil.readableFileSize((long)file.getSize());
        sysFileInfo.setFileSizeInfo(fileSizeInfo);
        String finalFileName = sysFileInfo.getFileId() + "." + fileSuffix;
        sysFileInfo.setFileObjectName(finalFileName);
        return sysFileInfo;
    }

    public static SysFileInfo createSysFileInfo(File file, SysFileInfoRequest sysFileInfoRequest) {
        SysFileInfo sysFileInfo = new SysFileInfo();
        FileInfoFactory.fillCommonInfo(sysFileInfo, sysFileInfoRequest);
        sysFileInfo.setFileOriginName(file.getName());
        String fileSuffix = null;
        if (ObjectUtil.isNotEmpty((Object)sysFileInfo.getFileOriginName())) {
            fileSuffix = StrUtil.subAfter((CharSequence)sysFileInfo.getFileOriginName(), (CharSequence)".", (boolean)true);
        }
        sysFileInfo.setFileSuffix(fileSuffix);
        long fileSizeKb = Convert.toLong((Object)NumberUtil.div((Number)new BigDecimal(file.length()), (Number)BigDecimal.valueOf(1024L)).setScale(0, 4));
        sysFileInfo.setFileSizeKb(fileSizeKb);
        String fileSizeInfo = FileUtil.readableFileSize((long)file.length());
        sysFileInfo.setFileSizeInfo(fileSizeInfo);
        String finalFileName = sysFileInfo.getFileId() + "." + fileSuffix;
        sysFileInfo.setFileObjectName(finalFileName);
        return sysFileInfo;
    }

    private static void fillCommonInfo(SysFileInfo sysFileInfo, SysFileInfoRequest sysFileInfoRequest) {
        Long fileId = IdWorker.getId();
        sysFileInfo.setFileId(fileId);
        sysFileInfo.setFileCode(IdWorker.getId());
        sysFileInfo.setFileVersion(1);
        sysFileInfo.setFileStatus(FileStatusEnum.NEW.getCode());
        if (FileLocationEnum.DB.getCode().equals(sysFileInfoRequest.getFileLocation())) {
            sysFileInfo.setFileLocation(FileLocationEnum.DB.getCode());
        } else {
            FileOperatorApi fileOperatorApi = (FileOperatorApi)SpringUtil.getBean(FileOperatorApi.class);
            sysFileInfo.setFileLocation(fileOperatorApi.getFileLocationEnum().getCode());
        }
        String fileBucket = FileConfigExpander.getDefaultBucket();
        if (StrUtil.isNotEmpty((CharSequence)sysFileInfoRequest.getFileBucket())) {
            fileBucket = sysFileInfoRequest.getFileBucket();
        }
        sysFileInfo.setFileBucket(fileBucket);
        sysFileInfo.setSecretFlag(sysFileInfoRequest.getSecretFlag());
    }
}

