/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.modular.service.impl;

import cn.stylefeng.roses.kernel.file.api.pojo.request.SysFileInfoRequest;
import cn.stylefeng.roses.kernel.file.api.pojo.response.SysFileInfoResponse;
import cn.stylefeng.roses.kernel.file.modular.entity.SysFileInfo;
import cn.stylefeng.roses.kernel.file.modular.factory.FileInfoFactory;
import cn.stylefeng.roses.kernel.file.modular.service.MultipleFileService;
import cn.stylefeng.roses.kernel.file.modular.service.SysFileInfoService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MultipleFileServiceImpl
implements MultipleFileService {
    @Resource
    private SysFileInfoService sysFileInfoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SysFileInfoResponse> batchUploadFile(MultipartFile[] fileList, SysFileInfoRequest sysFileInfoRequest) {
        Map<MultipartFile, SysFileInfo> multipartFileSysFileInfoMap = FileInfoFactory.batchCreateFileInfo(fileList, sysFileInfoRequest);
        for (Map.Entry<MultipartFile, SysFileInfo> entry : multipartFileSysFileInfoMap.entrySet()) {
            MultipartFile file = entry.getKey();
            SysFileInfo fileInfo = entry.getValue();
            this.sysFileInfoService.storageFile(file, fileInfo);
        }
        Collection<SysFileInfo> sysFileInfos = multipartFileSysFileInfoMap.values();
        this.sysFileInfoService.saveBatch(sysFileInfos);
        ArrayList<SysFileInfoResponse> fileInfoResponses = new ArrayList<SysFileInfoResponse>();
        for (SysFileInfo sysFileInfo : sysFileInfos) {
            SysFileInfoResponse fileInfoResponse = this.sysFileInfoService.getFileInfoResponse(sysFileInfo);
            fileInfoResponses.add(fileInfoResponse);
        }
        return fileInfoResponses;
    }
}

