/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.file.api.FileInfoApi;
import cn.stylefeng.roses.kernel.file.api.pojo.response.SysFileInfoResponse;
import cn.stylefeng.roses.kernel.file.modular.entity.SysFileBusiness;
import cn.stylefeng.roses.kernel.file.modular.enums.SysFileBusinessExceptionEnum;
import cn.stylefeng.roses.kernel.file.modular.mapper.SysFileBusinessMapper;
import cn.stylefeng.roses.kernel.file.modular.pojo.request.SysFileBusinessRequest;
import cn.stylefeng.roses.kernel.file.modular.service.SysFileBusinessService;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysFileBusinessServiceImpl
extends ServiceImpl<SysFileBusinessMapper, SysFileBusiness>
implements SysFileBusinessService {
    @Resource
    private FileInfoApi fileInfoApi;

    @Override
    public void add(SysFileBusinessRequest sysFileBusinessRequest) {
        SysFileBusiness sysFileBusiness = new SysFileBusiness();
        BeanUtil.copyProperties((Object)((Object)sysFileBusinessRequest), (Object)((Object)sysFileBusiness), (String[])new String[0]);
        this.save((Object)sysFileBusiness);
    }

    @Override
    public void del(SysFileBusinessRequest sysFileBusinessRequest) {
        SysFileBusiness sysFileBusiness = this.querySysFileBusiness(sysFileBusinessRequest);
        this.removeById(sysFileBusiness.getFileBusinessId());
    }

    @Override
    public void edit(SysFileBusinessRequest sysFileBusinessRequest) {
        SysFileBusiness sysFileBusiness = this.querySysFileBusiness(sysFileBusinessRequest);
        BeanUtil.copyProperties((Object)((Object)sysFileBusinessRequest), (Object)((Object)sysFileBusiness), (String[])new String[0]);
        this.updateById((Object)sysFileBusiness);
    }

    @Override
    public SysFileBusiness detail(SysFileBusinessRequest sysFileBusinessRequest) {
        return this.querySysFileBusiness(sysFileBusinessRequest);
    }

    @Override
    public PageResult<SysFileBusiness> findPage(SysFileBusinessRequest sysFileBusinessRequest) {
        LambdaQueryWrapper<SysFileBusiness> wrapper = this.createWrapper(sysFileBusinessRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<SysFileBusiness> findList(SysFileBusinessRequest sysFileBusinessRequest) {
        LambdaQueryWrapper<SysFileBusiness> wrapper = this.createWrapper(sysFileBusinessRequest);
        return this.list((Wrapper)wrapper);
    }

    public void addFileBusinessBind(String businessCode, Long businessId, List<Long> fileIdList) {
        if (ObjectUtil.isEmpty(fileIdList) || ObjectUtil.isEmpty((Object)businessCode) || ObjectUtil.isEmpty((Object)businessId)) {
            return;
        }
        this.removeBusinessIdFileList(businessCode, businessId);
        ArrayList<SysFileBusiness> sysFileBusinesses = new ArrayList<SysFileBusiness>();
        for (Long fileId : fileIdList) {
            SysFileBusiness sysFileBusiness = new SysFileBusiness();
            sysFileBusiness.setBusinessCode(businessCode);
            sysFileBusiness.setBusinessId(businessId);
            sysFileBusiness.setFileId(fileId);
            sysFileBusinesses.add(sysFileBusiness);
        }
        this.saveBatch(sysFileBusinesses);
    }

    public List<SysFileInfoResponse> getBusinessFileInfoList(Long businessId) {
        LambdaQueryWrapper sysFileBusinessLambdaQueryWrapper = new LambdaQueryWrapper();
        sysFileBusinessLambdaQueryWrapper.eq(SysFileBusiness::getBusinessId, (Object)businessId);
        List list = this.list((Wrapper)sysFileBusinessLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)list)) {
            return new ArrayList<SysFileInfoResponse>();
        }
        ArrayList<SysFileInfoResponse> sysFileInfoResponses = new ArrayList<SysFileInfoResponse>();
        for (SysFileBusiness sysFileBusiness : list) {
            Long fileId = sysFileBusiness.getFileId();
            SysFileInfoResponse fileInfoWithoutContent = this.fileInfoApi.getFileInfoWithoutContent(fileId);
            if (fileInfoWithoutContent == null) continue;
            fileInfoWithoutContent.setDownloadCount(sysFileBusiness.getDownloadCount());
            fileInfoWithoutContent.setUploadUserId(sysFileBusiness.getCreateUser());
            fileInfoWithoutContent.setUploadTime(sysFileBusiness.getCreateTime());
            sysFileInfoResponses.add(fileInfoWithoutContent);
        }
        return sysFileInfoResponses;
    }

    public void addFileDownloadCount(Long businessId, Long fileId) {
        LambdaQueryWrapper sysFileBusinessLambdaQueryWrapper = new LambdaQueryWrapper();
        sysFileBusinessLambdaQueryWrapper.eq(SysFileBusiness::getBusinessId, (Object)businessId);
        sysFileBusinessLambdaQueryWrapper.eq(SysFileBusiness::getFileId, (Object)fileId);
        SysFileBusiness sysFileBusiness = (SysFileBusiness)((Object)this.getOne((Wrapper)sysFileBusinessLambdaQueryWrapper, false));
        if (sysFileBusiness != null) {
            sysFileBusiness.setDownloadCount(sysFileBusiness.getDownloadCount() + 1);
            this.updateById((Object)sysFileBusiness);
        }
    }

    public void removeBusinessIdFileList(String businessCode, Long businessId) {
        if (ObjectUtil.isEmpty((Object)businessCode) || ObjectUtil.isEmpty((Object)businessId)) {
            return;
        }
        LambdaQueryWrapper sysFileBusinessLambdaQueryWrapper = new LambdaQueryWrapper();
        sysFileBusinessLambdaQueryWrapper.eq(SysFileBusiness::getBusinessCode, (Object)businessCode);
        sysFileBusinessLambdaQueryWrapper.eq(SysFileBusiness::getBusinessId, (Object)businessId);
        this.remove((Wrapper)sysFileBusinessLambdaQueryWrapper);
    }

    private SysFileBusiness querySysFileBusiness(SysFileBusinessRequest sysFileBusinessRequest) {
        SysFileBusiness sysFileBusiness = (SysFileBusiness)((Object)this.getById(sysFileBusinessRequest.getFileBusinessId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysFileBusiness))) {
            throw new ServiceException((AbstractExceptionEnum)SysFileBusinessExceptionEnum.SYS_FILE_BUSINESS_NOT_EXISTED);
        }
        return sysFileBusiness;
    }

    private LambdaQueryWrapper<SysFileBusiness> createWrapper(SysFileBusinessRequest sysFileBusinessRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long businessId = sysFileBusinessRequest.getBusinessId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)businessId), SysFileBusiness::getBusinessId, (Object)businessId);
        return queryWrapper;
    }
}

