/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.group.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.group.api.callback.GroupNameCallbackApi;
import cn.stylefeng.roses.kernel.group.api.pojo.SysGroupDTO;
import cn.stylefeng.roses.kernel.group.api.pojo.SysGroupRequest;
import cn.stylefeng.roses.kernel.group.modular.entity.SysGroup;
import cn.stylefeng.roses.kernel.group.modular.mapper.SysGroupMapper;
import cn.stylefeng.roses.kernel.group.modular.service.SysGroupService;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysGroupServiceImpl
extends ServiceImpl<SysGroupMapper, SysGroup>
implements SysGroupService {
    public List<SysGroupDTO> findGroupList(SysGroupRequest sysGroupRequest, boolean getTotal) {
        Long userId;
        List<Object> sysGroupDTOS = new ArrayList<SysGroupDTO>();
        String groupBizCode = sysGroupRequest.getGroupBizCode();
        LambdaQueryWrapper<SysGroup> wrapper = this.createWrapper(groupBizCode, userId = LoginContext.me().getLoginUser().getUserId(), getTotal);
        List list2 = this.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)list2)) {
            sysGroupDTOS = BeanUtil.copyToList((Collection)list2, SysGroupDTO.class);
        }
        this.addAllGroup(groupBizCode, sysGroupDTOS);
        return sysGroupDTOS;
    }

    @Override
    public List<SysGroupDTO> addSelect(SysGroupRequest sysGroupRequest) {
        Long userId;
        List<Object> sysGroupDTOS = new ArrayList<SysGroupDTO>();
        String groupBizCode = sysGroupRequest.getGroupBizCode();
        LambdaQueryWrapper<SysGroup> wrapper = this.createWrapper(groupBizCode, userId = LoginContext.me().getLoginUser().getUserId(), false);
        List list2 = this.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)list2)) {
            sysGroupDTOS = BeanUtil.copyToList((Collection)list2, SysGroupDTO.class);
        }
        this.addCommonGroup(groupBizCode, sysGroupDTOS);
        return sysGroupDTOS;
    }

    @Override
    public void add(SysGroupRequest sysGroupRequest) {
        ArrayList<SysGroup> sysGroups = new ArrayList<SysGroup>();
        Long userId = LoginContext.me().getLoginUser().getUserId();
        List businessIdList = sysGroupRequest.getBusinessIdList();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SysGroup::getGroupBizCode, (Object)sysGroupRequest.getGroupBizCode());
        updateWrapper.in(SysGroup::getBusinessId, (Collection)businessIdList);
        updateWrapper.eq(SysGroup::getUserId, (Object)userId);
        this.remove((Wrapper)updateWrapper);
        if (!"\u672a\u5206\u7ec4".equals(sysGroupRequest.getGroupName())) {
            for (Long bizId : businessIdList) {
                SysGroup sysGroup = new SysGroup();
                sysGroup.setGroupName(sysGroupRequest.getGroupName());
                sysGroup.setGroupBizCode(sysGroupRequest.getGroupBizCode());
                sysGroup.setBusinessId(bizId);
                sysGroup.setUserId(userId);
                sysGroups.add(sysGroup);
            }
            this.saveBatch(sysGroups);
        }
    }

    @Override
    public void del(SysGroupRequest sysGroupRequest) {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysGroup::getUserId, (Object)userId);
        wrapper.eq(SysGroup::getGroupBizCode, (Object)sysGroupRequest.getGroupBizCode());
        wrapper.in(SysGroup::getBusinessId, (Collection)sysGroupRequest.getBusinessIdList());
        this.remove((Wrapper)wrapper);
    }

    public List<Long> findUserGroupDataList(SysGroupRequest sysGroupRequest) {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaQueryWrapper sysGroupLambdaQueryWrapper = new LambdaQueryWrapper();
        sysGroupLambdaQueryWrapper.eq(SysGroup::getUserId, (Object)userId);
        sysGroupLambdaQueryWrapper.eq(SysGroup::getGroupBizCode, (Object)sysGroupRequest.getGroupBizCode());
        sysGroupLambdaQueryWrapper.eq(StrUtil.isNotBlank((CharSequence)sysGroupRequest.getGroupName()), SysGroup::getGroupName, (Object)sysGroupRequest.getGroupName());
        List list2 = this.list((Wrapper)sysGroupLambdaQueryWrapper);
        if (list2 == null || list2.size() == 0) {
            return new ArrayList<Long>();
        }
        return list2.stream().map(SysGroup::getBusinessId).collect(Collectors.toList());
    }

    public void removeGroup(String bizCode, Long bizId) {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysGroup::getUserId, (Object)userId);
        wrapper.eq(SysGroup::getGroupBizCode, (Object)bizCode);
        wrapper.eq(SysGroup::getBusinessId, (Object)bizId);
        this.remove((Wrapper)wrapper);
    }

    public Boolean getRequestUnGroupedFlag(BaseRequest baseRequest) {
        String conditionGroupName = baseRequest.getConditionGroupName();
        return "\u672a\u5206\u7ec4".equals(conditionGroupName);
    }

    public List<Long> getUserGroupBizIds(String groupBizCode, BaseRequest baseRequest) {
        String conditionGroupName = baseRequest.getConditionGroupName();
        List<Long> userBizIds = new ArrayList<Long>();
        if (ObjectUtil.isNotEmpty((Object)conditionGroupName) && !conditionGroupName.equals("\u6240\u6709\u5206\u7ec4")) {
            SysGroupRequest sysGroupRequest = new SysGroupRequest();
            sysGroupRequest.setGroupBizCode(groupBizCode);
            if (!this.getRequestUnGroupedFlag(baseRequest).booleanValue()) {
                sysGroupRequest.setGroupName(conditionGroupName);
            }
            userBizIds = this.findUserGroupDataList(sysGroupRequest);
        }
        return userBizIds;
    }

    public void renderBizListGroupName(String groupBizCode, List<? extends GroupNameCallbackApi> businessList) {
        if (ObjectUtil.isEmpty(businessList)) {
            return;
        }
        SysGroupRequest sysGroupRequest = new SysGroupRequest();
        sysGroupRequest.setGroupBizCode(groupBizCode);
        List<SysGroupDTO> list2 = this.findGroupList(sysGroupRequest, true);
        for (SysGroupDTO sysGroupDTO : list2) {
            for (GroupNameCallbackApi groupNameCallbackApi : businessList) {
                if (!groupNameCallbackApi.getRenderBusinessId().equals(sysGroupDTO.getBusinessId())) continue;
                groupNameCallbackApi.renderGroupName(sysGroupDTO.getGroupName());
            }
        }
    }

    private void addCommonGroup(String groupBizCode, List<SysGroupDTO> result) {
        SysGroupDTO addGroup = new SysGroupDTO();
        addGroup.setGroupBizCode(groupBizCode);
        addGroup.setGroupName("\u6dfb\u52a0\u5206\u7ec4");
        SysGroupDTO noneGroup = new SysGroupDTO();
        noneGroup.setGroupBizCode(groupBizCode);
        noneGroup.setGroupName("\u672a\u5206\u7ec4");
        result.add(0, noneGroup);
        result.add(0, addGroup);
    }

    private void addAllGroup(String groupBizCode, List<SysGroupDTO> result) {
        SysGroupDTO addGroup = new SysGroupDTO();
        addGroup.setGroupBizCode(groupBizCode);
        addGroup.setGroupName("\u6240\u6709\u5206\u7ec4");
        SysGroupDTO noneGroup = new SysGroupDTO();
        noneGroup.setGroupBizCode(groupBizCode);
        noneGroup.setGroupName("\u672a\u5206\u7ec4");
        result.add(0, noneGroup);
        result.add(0, addGroup);
    }

    private LambdaQueryWrapper<SysGroup> createWrapper(String groupBizCode, Long userId, Boolean getTotal) {
        LambdaQueryWrapper sysGroupLambdaQueryWrapper = new LambdaQueryWrapper();
        sysGroupLambdaQueryWrapper.eq(SysGroup::getGroupBizCode, (Object)groupBizCode);
        sysGroupLambdaQueryWrapper.eq(SysGroup::getUserId, (Object)userId);
        if (getTotal != null && !getTotal.booleanValue()) {
            sysGroupLambdaQueryWrapper.groupBy(SysGroup::getGroupName);
        }
        sysGroupLambdaQueryWrapper.select(new SFunction[]{SysGroup::getGroupName, SysGroup::getGroupId, SysGroup::getGroupBizCode, SysGroup::getBusinessId, SysGroup::getUserId});
        return sysGroupLambdaQueryWrapper;
    }
}

