/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.enums;

import lombok.Generated;

public enum DbTypeEnum {
    MYSQL("jdbc:mysql", "mysql", "select 1"),
    PG_SQL("jdbc:postgresql", "pgsql", "select version()"),
    ORACLE("jdbc:oracle", "oracle", "select 1 from dual"),
    MS_SQL("jdbc:jtds:sqlserver", "mssql", "select 1"),
    DM("jdbc:dm", "dm", "select 1 from dual"),
    VAST_DATA("jdbc:vastbase", "vastbase", "select version()"),
    KING_BASE("jdbc:kingbase8", "kingbase8", "select version()"),
    OPEN_GAUSS("jdbc:opengauss", "opengauss", "select version()");

    private final String urlWords;
    private final String xmlDatabaseId;
    private final String validateQuery;

    private DbTypeEnum(String urlWords, String xmlDatabaseId, String validateQuery) {
        this.urlWords = urlWords;
        this.xmlDatabaseId = xmlDatabaseId;
        this.validateQuery = validateQuery;
    }

    public static String getTypeByUrl(String url) {
        if (url == null) {
            return MYSQL.name();
        }
        for (DbTypeEnum value : DbTypeEnum.values()) {
            if (!url.contains(value.getUrlWords())) continue;
            return value.name();
        }
        return MYSQL.name();
    }

    @Generated
    public String getUrlWords() {
        return this.urlWords;
    }

    @Generated
    public String getXmlDatabaseId() {
        return this.xmlDatabaseId;
    }

    @Generated
    public String getValidateQuery() {
        return this.validateQuery;
    }
}

