/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.tree.factory;

import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.rule.tree.factory.base.AbstractSortedTreeNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;

public class SortedTreeBuildFactory<T extends AbstractSortedTreeNode<T>>
extends DefaultTreeBuildFactory<T> {
    public SortedTreeBuildFactory() {
    }

    public SortedTreeBuildFactory(String rootParentId) {
        super(rootParentId);
    }

    @Override
    public List<T> doTreeBuild(List<T> nodes) {
        nodes.sort(Comparator.comparing(AbstractSortedTreeNode::getSort));
        for (AbstractSortedTreeNode treeNode : nodes) {
            this.buildChildNodes(nodes, treeNode, new ArrayList());
        }
        ArrayList<AbstractSortedTreeNode> results = new ArrayList<AbstractSortedTreeNode>();
        for (AbstractSortedTreeNode node : nodes) {
            if (!node.getNodeParentId().equals(this.getRootParentId())) continue;
            results.add(node);
        }
        return results;
    }

    @Override
    protected void buildChildNodes(List<T> totalNodes, T node, List<T> childNodeLists) {
        if (totalNodes == null || node == null) {
            return;
        }
        List<T> nodeSubLists = this.getSubChildsLevelOne(totalNodes, node);
        nodeSubLists.sort(Comparator.comparing(AbstractSortedTreeNode::getSort));
        if (!nodeSubLists.isEmpty()) {
            for (AbstractSortedTreeNode nodeSubList : nodeSubLists) {
                this.buildChildNodes(totalNodes, nodeSubList, new ArrayList());
            }
        }
        childNodeLists.addAll(nodeSubLists);
        node.setChildrenNodes(childNodeLists);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortedTreeBuildFactory)) {
            return false;
        }
        SortedTreeBuildFactory other = (SortedTreeBuildFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SortedTreeBuildFactory;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SortedTreeBuildFactory()";
    }
}

