/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.code;

import cn.stylefeng.roses.kernel.rule.code.CodeStrategy;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class UniqueTraceCodeGenerator {
    private static volatile UniqueTraceCodeGenerator instance;

    private UniqueTraceCodeGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UniqueTraceCodeGenerator getInstance() {
        if (instance != null) return instance;
        Class<UniqueTraceCodeGenerator> clazz = UniqueTraceCodeGenerator.class;
        synchronized (UniqueTraceCodeGenerator.class) {
            if (instance != null) return instance;
            instance = new UniqueTraceCodeGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String generateCode(CodeStrategy strategy, int length) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String hashedUuid = this.hash(uuid);
        return this.convert(hashedUuid, strategy, length);
    }

    private String hash(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u54c8\u5e0c\u7b97\u6cd5\u5f02\u5e38", e);
        }
    }

    private String convert(String input, CodeStrategy strategy, int fixLength) {
        StringBuilder sb = new StringBuilder();
        int base = strategy.base;
        String charset = strategy.charset;
        for (int i = 0; i < input.length(); i += 2) {
            String hex = input.substring(i, i + 2);
            int byteValue = Integer.parseInt(hex, 16);
            sb.append(charset.charAt(byteValue % base));
        }
        while (sb.length() < fixLength) {
            sb.append(charset.charAt(0));
        }
        if (sb.length() > fixLength) {
            sb.setLength(fixLength);
        }
        return sb.toString();
    }
}

