/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.util;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

public class AopTargetUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AopTargetUtils.class);

    public static Object getTarget(Object proxy) {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        try {
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                return AopTargetUtils.getJdkDynamicProxyTargetObject(proxy);
            }
            return AopTargetUtils.getCglibProxyTargetObject(proxy);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4ee3\u7406\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        if (proxy instanceof Advised) {
            Advised advised = (Advised)proxy;
            return advised.getTargetSource().getTarget();
        }
        throw new IllegalArgumentException("Not a CGLIB proxy");
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        if (proxy instanceof Advised) {
            Advised advised = (Advised)proxy;
            return advised.getTargetSource().getTarget();
        }
        throw new IllegalArgumentException("Not a JDK dynamic proxy");
    }
}

