/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.rule.pojo.response.ErrorResponseData;

public class ExceptionUtil {
    public static String getFirstStackTraceByPackageName(Throwable throwable, String packageName) {
        if (ObjectUtil.hasEmpty((Object[])new Object[]{throwable})) {
            return "";
        }
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        String stackTraceElementString = stackTraceElements[0].toString();
        if (StrUtil.isEmpty((CharSequence)packageName)) {
            return stackTraceElementString;
        }
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (!stackTraceElement.toString().contains(packageName)) continue;
            stackTraceElementString = stackTraceElement.toString();
            break;
        }
        return stackTraceElementString;
    }

    public static void fillErrorResponseData(ErrorResponseData errorResponseData, Throwable throwable, String projectPackage) {
        if (errorResponseData == null || throwable == null) {
            return;
        }
        errorResponseData.setExceptionClazz(throwable.getClass().getSimpleName());
        errorResponseData.setExceptionTip(throwable.getMessage());
        errorResponseData.setExceptionPlace(ExceptionUtil.getFirstStackTraceByPackageName(throwable, projectPackage));
    }
}

