/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.ContentType;
import cn.stylefeng.roses.kernel.rule.pojo.response.ErrorResponseData;
import com.alibaba.fastjson.JSON;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseRenderUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponseRenderUtil.class);

    public static void renderJsonResponse(HttpServletResponse response, Object responseData) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(ContentType.JSON.toString());
        String errorResponseJsonData = JSON.toJSONString((Object)responseData);
        try {
            response.getWriter().write(errorResponseJsonData);
        }
        catch (IOException e) {
            log.error("\u6e32\u67d3http json\u4fe1\u606f\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public static void renderErrorResponse(HttpServletResponse response, String code, String message, String exceptionClazz) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(ContentType.JSON.toString());
        ErrorResponseData errorResponseData = new ErrorResponseData(code, message);
        errorResponseData.setExceptionClazz(exceptionClazz);
        String errorResponseJsonData = JSON.toJSONString(errorResponseData);
        try {
            response.getWriter().write(errorResponseJsonData);
        }
        catch (IOException e) {
            log.error("\u6e32\u67d3http json\u4fe1\u606f\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    public static void setRenderFileHeader(HttpServletResponse response, String fileName) {
        String charset = (String)ObjectUtil.defaultIfNull((Object)response.getCharacterEncoding(), (Object)"UTF-8");
        response.setHeader("Content-Disposition", StrUtil.format((CharSequence)"attachment;filename={}", (Object[])new Object[]{URLUtil.encode((String)fileName, (Charset)Charset.forName(charset))}));
        response.setContentType("application/octet-stream; charset=utf-8");
    }

    public static void setRenderImageHeader(HttpServletResponse response) {
        response.setContentType("image/png");
    }

    public static void setRenderExcelHeader(HttpServletResponse response, String fileName) {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error("excel\u6587\u4ef6\u540d\u7f16\u7801\u9519\u8bef\uff01", (Throwable)e);
        }
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
    }
}

