/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.api.schedule;

import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.log.api.LoginLogServiceApi;
import cn.stylefeng.roses.kernel.log.api.SecurityLogServiceApi;
import cn.stylefeng.roses.kernel.log.api.pojo.security.LogSecurityRequest;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncLogManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncLogManager.class);
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(10);
    public static AsyncLogManager logManager = new AsyncLogManager();

    private AsyncLogManager() {
    }

    public static AsyncLogManager getInstance() {
        return logManager;
    }

    public void executeLog(TimerTask task) {
        int delayTime = 10;
        this.executor.schedule(task, (long)delayTime, TimeUnit.MILLISECONDS);
    }

    public void recordLoginLogFail(final String account, final String ip) {
        this.executeLog(new TimerTask(){

            @Override
            public void run() {
                try {
                    LoginLogServiceApi loginLogServiceApi = (LoginLogServiceApi)SpringUtil.getBean(LoginLogServiceApi.class);
                    loginLogServiceApi.loginFail(account, ip);
                }
                catch (Exception e) {
                    log.error("\u8bb0\u5f55\u767b\u5f55\u5931\u8d25\u65e5\u5fd7\u5f02\u5e38\uff01", (Throwable)e);
                }
            }
        });
    }

    public void recordSecurityLog(final LogSecurityRequest logSecurityRequest) {
        this.executeLog(new TimerTask(){

            @Override
            public void run() {
                try {
                    SecurityLogServiceApi securityLogServiceApi = (SecurityLogServiceApi)SpringUtil.getBean(SecurityLogServiceApi.class);
                    securityLogServiceApi.add(logSecurityRequest);
                }
                catch (Exception e) {
                    log.error("\u8bb0\u5f55\u5b89\u5168\u65e5\u5fd7\u5f02\u5e38\uff01", (Throwable)e);
                }
            }
        });
    }
}

