/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.requestapi;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.log.api.pojo.record.LogRecordDTO;
import cn.stylefeng.roses.kernel.log.api.threadpool.LogManagerThreadPool;
import cn.stylefeng.roses.kernel.log.requestapi.LogRecordApi;
import cn.stylefeng.roses.kernel.log.requestapi.entity.SysLog;
import cn.stylefeng.roses.kernel.log.requestapi.service.SysLogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbLogRecordServiceImpl
implements LogRecordApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbLogRecordServiceImpl.class);
    private final SysLogService sysLogService;
    private final LogManagerThreadPool logManagerThreadPool;
    private final LogRefreshManager logRefreshManager;

    public DbLogRecordServiceImpl(LogManagerThreadPool logManagerThreadPool, SysLogService sysLogService) {
        this.logManagerThreadPool = logManagerThreadPool;
        this.sysLogService = sysLogService;
        this.logRefreshManager = new LogRefreshManager();
        this.logRefreshManager.start();
    }

    public DbLogRecordServiceImpl(LogManagerThreadPool logManagerThreadPool, SysLogService sysLogService, long sleepTime, int maxCount) {
        this.logManagerThreadPool = logManagerThreadPool;
        this.sysLogService = sysLogService;
        this.logRefreshManager = new LogRefreshManager(sleepTime, maxCount);
        this.logRefreshManager.start();
    }

    @Override
    public void add(LogRecordDTO logRecordDTO) {
        if (logRecordDTO == null) {
            return;
        }
        this.addBatch(CollectionUtil.list((boolean)false, (Object[])new LogRecordDTO[]{logRecordDTO}));
    }

    @Override
    public void addBatch(List<LogRecordDTO> logRecords) {
        if (ObjectUtil.isEmpty(logRecords)) {
            return;
        }
        List sysLogList = logRecords.stream().map(logRecordDTO -> {
            SysLog sysLog = new SysLog();
            BeanUtil.copyProperties((Object)logRecordDTO, (Object)((Object)sysLog), (String[])new String[0]);
            if (StrUtil.isEmpty((CharSequence)sysLog.getAppName())) {
                sysLog.setAppName("none-app-name");
            }
            return sysLog;
        }).collect(Collectors.toList());
        this.sysLogService.saveBatch(sysLogList);
    }

    @Override
    public void addAsync(final LogRecordDTO logRecordDTO) {
        this.logManagerThreadPool.executeLog(new TimerTask(){

            @Override
            public void run() {
                DbLogRecordServiceImpl.this.logRefreshManager.putLog(logRecordDTO);
            }
        });
    }

    class LogRefreshManager
    extends Thread {
        private final long sleepTime;
        private final int maxCount;
        private final AtomicLong refreshMark = new AtomicLong();
        private final Queue<LogRecordDTO> queue = new ConcurrentLinkedQueue<LogRecordDTO>();
        public AtomicInteger count = new AtomicInteger(0);

        public LogRefreshManager() {
            this.sleepTime = 3000L;
            this.maxCount = 300;
        }

        public LogRefreshManager(long sleepTime) {
            this.sleepTime = sleepTime;
            this.maxCount = 300;
        }

        public LogRefreshManager(int maxCount) {
            this.sleepTime = 3000L;
            this.maxCount = maxCount;
        }

        public LogRefreshManager(long sleepTime, int maxCount) {
            this.sleepTime = sleepTime;
            this.maxCount = maxCount;
        }

        public void putLog(LogRecordDTO logRecordDTO) {
            int queueDataCount = this.count.get();
            if (queueDataCount == 0) {
                this.refreshMark.getAndSet(System.currentTimeMillis());
            }
            if (queueDataCount >= this.maxCount * 2) {
                return;
            }
            this.queue.offer(logRecordDTO);
            this.count.incrementAndGet();
        }

        private void refresh() {
            LogRecordDTO item;
            this.refreshMark.getAndSet(System.currentTimeMillis());
            int num = this.count.getAndSet(0);
            ArrayList<LogRecordDTO> cacheAll = new ArrayList<LogRecordDTO>(num);
            for (int i = 0; i < num && null != (item = this.queue.poll()); ++i) {
                cacheAll.add(item);
            }
            DbLogRecordServiceImpl.this.addBatch(cacheAll);
        }

        private void timing() {
            long currentTimeMillis = System.currentTimeMillis();
            if (this.refreshMark.get() + this.sleepTime <= currentTimeMillis && this.count.get() > 0) {
                this.refresh();
            }
        }

        private void listener() {
            if (this.count.get() >= this.maxCount) {
                this.refresh();
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.listener();
                    this.timing();
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                log.error(e.getMessage());
                return;
            }
        }
    }
}

