/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.business.aop;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.log.api.context.BusinessLogHolder;
import cn.stylefeng.roses.kernel.log.api.pojo.entity.SysLogBusiness;
import cn.stylefeng.roses.kernel.log.business.service.SysLogBusinessService;
import cn.stylefeng.roses.kernel.rule.annotation.BizLog;
import cn.stylefeng.roses.kernel.rule.constants.ProjectAopSortConstants;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class BusinessLogRecordAop
implements Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessLogRecordAop.class);
    @Resource
    private SysLogBusinessService sysLogBusinessService;

    @Pointcut(value="@annotation(cn.stylefeng.roses.kernel.rule.annotation.BizLog)")
    public void cutService() {
    }

    @Around(value="cutService()")
    public Object aroundPost(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            this.initBusinessContext(joinPoint);
            Object result = joinPoint.proceed();
            SysLogBusiness logContext = BusinessLogHolder.getContext();
            List contentList = BusinessLogHolder.getContent();
            if (ObjectUtil.isNotEmpty((Object)logContext) && ObjectUtil.isNotEmpty((Object)contentList)) {
                this.sysLogBusinessService.saveBatchLogs(logContext, contentList);
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u65e5\u5fd7\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw e;
        }
        finally {
            BusinessLogHolder.clearContext();
        }
    }

    private void initBusinessContext(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        BizLog bizLog = method.getAnnotation(BizLog.class);
        SysLogBusiness sysLogBusiness = new SysLogBusiness();
        sysLogBusiness.setBusinessLogId(Long.valueOf(IdWorker.getId()));
        sysLogBusiness.setLogTypeCode(bizLog.logTypeCode());
        try {
            sysLogBusiness.setRequestUrl(HttpServletUtil.getRequest().getServletPath());
            sysLogBusiness.setHttpMethod(HttpServletUtil.getRequest().getMethod());
            String requestClientIp = HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest());
            sysLogBusiness.setClientIp(requestClientIp);
        }
        catch (Exception requestClientIp) {
            // empty catch block
        }
        LoginUser loginUserNullable = LoginContext.me().getLoginUserNullable();
        if (loginUserNullable != null) {
            sysLogBusiness.setUserId(loginUserNullable.getUserId());
        }
        BusinessLogHolder.setContext((SysLogBusiness)sysLogBusiness);
    }

    public int getOrder() {
        return ProjectAopSortConstants.DEFAULT_BUSINESS_LOG_AOP_SORT;
    }
}

