/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.util;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.rule.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.rule.pojo.clazz.ClassParseResult;
import cn.stylefeng.roses.kernel.rule.util.ClassTypeUtil;
import cn.stylefeng.roses.kernel.scanner.api.pojo.scanner.ScannerProperties;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedClassTypeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvancedClassTypeUtil.class);
    public static List<String> TEMP_SCAN_PACKAGE_LIST = null;

    public static boolean ensureEntityFlag(Class<?> clazz) {
        if (TEMP_SCAN_PACKAGE_LIST == null) {
            Object packageStr = null;
            try {
                ScannerProperties properties = (ScannerProperties)SpringUtil.getBean(ScannerProperties.class);
                String entityScanPackage = properties.getEntityScanPackage();
                if (ObjectUtil.isEmpty((Object)entityScanPackage)) {
                    TEMP_SCAN_PACKAGE_LIST = new ArrayList<String>();
                    return false;
                }
                Object[] scanPackages = entityScanPackage.split(",");
                TEMP_SCAN_PACKAGE_LIST = ListUtil.toLinkedList((Object[])scanPackages);
            }
            catch (Exception e) {
                TEMP_SCAN_PACKAGE_LIST = new ArrayList<String>();
                return false;
            }
        }
        for (String packageName : TEMP_SCAN_PACKAGE_LIST) {
            if (!clazz.getName().startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public static ClassParseResult getClassFieldType(Type type) {
        if (type == null) {
            return new ClassParseResult(FieldTypeEnum.OTHER, null);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (ClassTypeUtil.validateNumericTypeFlag((Class)clazz)) {
                ClassParseResult classParseResult = new ClassParseResult(FieldTypeEnum.NUMBER, null);
                classParseResult.setOriginType(type);
                return classParseResult;
            }
            if (ClassUtil.isSimpleValueType((Class)clazz)) {
                ClassParseResult classParseResult = new ClassParseResult(FieldTypeEnum.STRING, null);
                classParseResult.setOriginType(type);
                return classParseResult;
            }
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                return new ClassParseResult(FieldTypeEnum.ARRAY, componentType);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new ClassParseResult(FieldTypeEnum.COLLECTION, null);
            }
            if (AdvancedClassTypeUtil.ensureEntityFlag(clazz)) {
                ClassParseResult classParseResult = new ClassParseResult(FieldTypeEnum.OBJECT, null);
                classParseResult.setOriginType(type);
                return classParseResult;
            }
            log.debug("\u7c7b\u578b\u662fClass\uff0c\u4f46\u6709\u5904\u7406\u4e0d\u5230\u7684\u60c5\u51b5\uff0c\u6253\u5370\u51fa\u7c7b\u7684\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)clazz.toGenericString());
            return new ClassParseResult(FieldTypeEnum.OTHER, null);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawTypeClass = (Class)parameterizedType.getRawType();
            Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
            if (Collection.class.isAssignableFrom(rawTypeClass)) {
                if (actualTypeArgument.getTypeName().equals("T")) {
                    return new ClassParseResult(FieldTypeEnum.WITH_UNKNOWN_ARRAY_GENERIC, null);
                }
                return new ClassParseResult(FieldTypeEnum.COLLECTION, actualTypeArgument);
            }
            if (Map.class.isAssignableFrom(rawTypeClass)) {
                return new ClassParseResult(FieldTypeEnum.MAP, null);
            }
            if (AdvancedClassTypeUtil.ensureEntityFlag(rawTypeClass)) {
                return new ClassParseResult(FieldTypeEnum.OBJECT_WITH_GENERIC, actualTypeArgument, rawTypeClass);
            }
            log.debug("\u6cdb\u578b\u7684\u4e3b\u4f53\u60c5\u51b5\u4e0d\u786e\u5b9a\uff0c\u4e0d\u5904\u7406\uff0c\u6253\u5370\u51farawTypeClass\uff1a{}", (Object)rawTypeClass.getName());
            return new ClassParseResult(FieldTypeEnum.OTHER, null);
        }
        if (type.getTypeName().equals("T")) {
            return new ClassParseResult(FieldTypeEnum.WITH_UNKNOWN_OBJ_GENERIC, null);
        }
        log.debug("\u672a\u77e5\u7c7b\u578b\u7684\u5904\u7406\uff0c\u65e2\u4e0d\u662fclass\u4e5f\u4e0d\u662fParameterizedType\uff0c\u6253\u5370\u51fa\u7c7b\u7684\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)type.getTypeName());
        return new ClassParseResult(FieldTypeEnum.OTHER, null);
    }
}

