/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.guomi;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.symmetric.SM4;
import cn.stylefeng.roses.kernel.security.guomi.expander.GuomiConfigExpander;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class GuomiUtil {
    public static String sm2EncryptWithPublic(String text) {
        String publicKey = GuomiConfigExpander.getSM2PublicKey();
        if (publicKey.length() == 130) {
            publicKey = publicKey.substring(2);
        }
        String xhex = publicKey.substring(0, 64);
        String yhex = publicKey.substring(64, 128);
        ECPublicKeyParameters ecPublicKeyParameters = BCUtil.toSm2Params((String)xhex, (String)yhex);
        SM2 sm2 = new SM2(null, ecPublicKeyParameters);
        sm2.usePlainEncoding();
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        String hex = sm2.encryptHex(text, KeyType.PublicKey).substring(2);
        return Base64.encode((byte[])HexUtil.decodeHex((String)hex));
    }

    public static String sm2DecryptWithPrivate(String encryptedStr) {
        String sm2PrivateKey = GuomiConfigExpander.getSM2PrivateKey();
        ECPrivateKeyParameters privateKeyParameters = BCUtil.toSm2Params((String)sm2PrivateKey);
        SM2 sm2 = new SM2(privateKeyParameters, null);
        sm2.usePlainEncoding();
        sm2.setMode(SM2Engine.Mode.C1C3C2);
        return sm2.decryptStr("04" + HexUtil.encodeHexStr((byte[])Base64.decode((CharSequence)encryptedStr)), KeyType.PrivateKey);
    }

    public static String sm3(String text) {
        return SmUtil.sm3((String)text);
    }

    public static String sm4Encrypt(String text) {
        String sm4Key = GuomiConfigExpander.getSM4Key();
        SM4 sm4 = SmUtil.sm4((byte[])Base64.decode((CharSequence)sm4Key));
        return sm4.encryptBase64(text, StandardCharsets.UTF_8);
    }

    public static String sm4Decrypt(String encryptedStr) {
        String sm4Key = GuomiConfigExpander.getSM4Key();
        SM4 sm4 = SmUtil.sm4((byte[])Base64.decode((CharSequence)sm4Key));
        return sm4.decryptStr(encryptedStr, StandardCharsets.UTF_8);
    }
}

