/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.request.encrypt.request;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.security.request.encrypt.request.CustomDecryptHttpInputMessage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestBodyAdvice.class);

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        PostResource postResource = methodParameter.getAnnotatedElement().getAnnotation(PostResource.class);
        if (postResource == null) {
            return false;
        }
        return postResource.requiredEncryption();
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        Method method = parameter.getMethod();
        if (method == null) {
            return inputMessage;
        }
        PostResource postResource = method.getAnnotation(PostResource.class);
        if (postResource == null) {
            return inputMessage;
        }
        InputStream body = inputMessage.getBody();
        String encryptedJsonString = IoUtil.readUtf8((InputStream)body);
        if (StrUtil.isBlank((CharSequence)encryptedJsonString)) {
            return inputMessage;
        }
        return new CustomDecryptHttpInputMessage(inputMessage.getHeaders(), encryptedJsonString);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }
}

