/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.request.encrypt.response;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.security.request.encrypt.exception.EncryptionException;
import cn.stylefeng.roses.kernel.security.request.encrypt.exception.enums.EncryptionExceptionEnum;
import cn.stylefeng.roses.kernel.security.request.encrypt.holder.TempSm4KeyHolder;
import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptResponseBodyAdvice.class);

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> converterType) {
        PostResource postResource = methodParameter.getAnnotatedElement().getAnnotation(PostResource.class);
        if (postResource == null) {
            return false;
        }
        return postResource.requiredEncryption();
    }

    public Object beforeBodyWrite(@Nullable Object originBody, MethodParameter methodParameter, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (originBody == null) {
            return null;
        }
        if (!(originBody instanceof ResponseData)) {
            return originBody;
        }
        ResponseData responseData = (ResponseData)originBody;
        Object data = responseData.getData();
        if (data == null) {
            return originBody;
        }
        String sm4Key = TempSm4KeyHolder.getSm4Key();
        if (StrUtil.isBlank((CharSequence)sm4Key)) {
            throw new EncryptionException(EncryptionExceptionEnum.GET_SM4_KEY_ERROR);
        }
        String originJsonString = JSON.toJSONString((Object)data);
        SM4 sm4 = SmUtil.sm4((byte[])sm4Key.getBytes());
        String encryptBase64 = sm4.encryptBase64(originJsonString, StandardCharsets.UTF_8);
        responseData.setData((Object)encryptBase64);
        TempSm4KeyHolder.clearSm4Key();
        return responseData;
    }
}

