/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.org.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.dict.api.DictApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.sys.api.OrganizationServiceApi;
import cn.stylefeng.roses.kernel.sys.api.SysUserOrgServiceApi;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveOrgCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.enums.org.DetectModeEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserOrgDTO;
import cn.stylefeng.roses.kernel.sys.modular.org.entity.HrOrgApprover;
import cn.stylefeng.roses.kernel.sys.modular.org.enums.HrOrgApproverExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.org.factory.OrgApproverFactory;
import cn.stylefeng.roses.kernel.sys.modular.org.mapper.HrOrgApproverMapper;
import cn.stylefeng.roses.kernel.sys.modular.org.pojo.request.HrOrgApproverRequest;
import cn.stylefeng.roses.kernel.sys.modular.org.pojo.response.ApproverBindUserItem;
import cn.stylefeng.roses.kernel.sys.modular.org.service.HrOrgApproverService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HrOrgApproverServiceImpl
extends ServiceImpl<HrOrgApproverMapper, HrOrgApprover>
implements HrOrgApproverService,
RemoveOrgCallbackApi {
    @Resource
    private DictApi dictApi;
    @Resource
    private OrganizationServiceApi organizationServiceApi;
    @Resource
    private SysUserOrgServiceApi sysUserOrgServiceApi;

    @Override
    public void del(HrOrgApproverRequest hrOrgApproverRequest) {
        LambdaQueryWrapper<HrOrgApprover> wrapper = this.createWrapper(hrOrgApproverRequest);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public List<SimpleDict> getApproverTypeList() {
        return this.dictApi.getDictDetailsByDictTypeCode("org_approver_type", null);
    }

    @Override
    public List<HrOrgApprover> getOrgApproverList(HrOrgApproverRequest hrOrgApproverRequest) {
        List<SimpleDict> approverTypeList = this.getApproverTypeList();
        LambdaQueryWrapper hrOrgApproverLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgId, (Object)hrOrgApproverRequest.getOrgId());
        List orgTotalBindingList = this.list((Wrapper)hrOrgApproverLambdaQueryWrapper);
        Map<Object, Object> groupingByUsers = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)orgTotalBindingList)) {
            groupingByUsers = orgTotalBindingList.stream().collect(Collectors.groupingBy(HrOrgApprover::getOrgApproverType));
        }
        ArrayList<HrOrgApprover> resultList = new ArrayList<HrOrgApprover>();
        for (SimpleDict orgApproverType : approverTypeList) {
            List userList;
            HrOrgApprover hrOrgApprover = new HrOrgApprover();
            hrOrgApprover.setOrgApproverType(Convert.toInt((Object)orgApproverType.getCode()));
            if (ObjectUtil.isNotEmpty((Object)orgTotalBindingList) && ObjectUtil.isNotEmpty((Object)(userList = (List)groupingByUsers.get(hrOrgApprover.getOrgApproverType())))) {
                List<ApproverBindUserItem> bindUserItems = OrgApproverFactory.convertUserItem(userList);
                hrOrgApprover.setBindUserItemList(bindUserItems);
            }
            if (ObjectUtil.isEmpty(hrOrgApprover.getBindUserItemList())) {
                hrOrgApprover.setBindUserItemList(new ArrayList<ApproverBindUserItem>());
            }
            resultList.add(hrOrgApprover);
        }
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindUserList(HrOrgApproverRequest hrOrgApproverRequest) {
        LambdaQueryWrapper<HrOrgApprover> wrapper = this.createWrapper(hrOrgApproverRequest);
        List alreadyBindUsers = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)alreadyBindUsers)) {
            ArrayList<HrOrgApprover> tempApproverList = new ArrayList<HrOrgApprover>();
            for (Long userId : hrOrgApproverRequest.getUserIdList()) {
                HrOrgApprover hrOrgApprover = new HrOrgApprover();
                hrOrgApprover.setOrgId(hrOrgApproverRequest.getOrgId());
                hrOrgApprover.setOrgApproverType(hrOrgApproverRequest.getOrgApproverType());
                hrOrgApprover.setUserId(userId);
                tempApproverList.add(hrOrgApprover);
            }
            this.saveBatch(tempApproverList);
            return;
        }
        List alreadyBindUserIdList = alreadyBindUsers.stream().map(HrOrgApprover::getUserId).collect(Collectors.toList());
        ArrayList<HrOrgApprover> tempApprovers = new ArrayList<HrOrgApprover>();
        for (Long needToBindUserId : hrOrgApproverRequest.getUserIdList()) {
            boolean needToAdd = true;
            for (Long tempUserId : alreadyBindUserIdList) {
                if (!tempUserId.equals(needToBindUserId)) continue;
                needToAdd = false;
                break;
            }
            if (needToAdd) {
                HrOrgApprover hrOrgApprover = new HrOrgApprover();
                hrOrgApprover.setOrgId(hrOrgApproverRequest.getOrgId());
                hrOrgApprover.setOrgApproverType(hrOrgApproverRequest.getOrgApproverType());
                hrOrgApprover.setUserId(needToBindUserId);
                tempApprovers.add(hrOrgApprover);
            }
            this.saveBatch(tempApprovers);
        }
    }

    public List<Long> getUserMainOrgApprover(Long userId, Integer orgApproverType, Integer parentLevel, DetectModeEnum detectModeEnum) {
        UserOrgDTO userMainOrgInfo = this.sysUserOrgServiceApi.getUserMainOrgInfo(userId);
        Long orgId = userMainOrgInfo.getDeptId();
        if (ObjectUtil.isEmpty((Object)orgId)) {
            orgId = userMainOrgInfo.getCompanyId();
        }
        if (ObjectUtil.isEmpty((Object)orgId)) {
            return new ArrayList<Long>();
        }
        return this.getDeptOrgApprover(orgId, orgApproverType, parentLevel, detectModeEnum);
    }

    public List<Long> getDeptOrgApprover(Long deptId, Integer orgApproverType, Integer parentLevel, DetectModeEnum detectModeEnum) {
        Long parentLevelOrgId = this.organizationServiceApi.getParentLevelOrgId(deptId, parentLevel, detectModeEnum);
        if (ObjectUtil.isEmpty((Object)parentLevelOrgId)) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper hrOrgApproverLambdaQueryWrapper = new LambdaQueryWrapper();
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgId, (Object)parentLevelOrgId);
        hrOrgApproverLambdaQueryWrapper.eq(HrOrgApprover::getOrgApproverType, (Object)orgApproverType);
        List userList = this.list((Wrapper)hrOrgApproverLambdaQueryWrapper);
        return userList.stream().map(HrOrgApprover::getUserId).collect(Collectors.toList());
    }

    public void validateHaveOrgBind(Set<Long> beRemovedOrgIdList) {
    }

    public void removeOrgAction(Set<Long> beRemovedOrgIdList) {
        LambdaUpdateWrapper hrOrgApproverLambdaUpdateWrapper = new LambdaUpdateWrapper();
        hrOrgApproverLambdaUpdateWrapper.in(HrOrgApprover::getOrgId, beRemovedOrgIdList);
        this.remove((Wrapper)hrOrgApproverLambdaUpdateWrapper);
    }

    private HrOrgApprover queryHrOrgApprover(HrOrgApproverRequest hrOrgApproverRequest) {
        HrOrgApprover hrOrgApprover = (HrOrgApprover)((Object)this.getById(hrOrgApproverRequest.getOrgApproverId()));
        if (ObjectUtil.isEmpty((Object)((Object)hrOrgApprover))) {
            throw new ServiceException((AbstractExceptionEnum)HrOrgApproverExceptionEnum.HR_ORG_APPROVER_NOT_EXISTED);
        }
        return hrOrgApprover;
    }

    private LambdaQueryWrapper<HrOrgApprover> createWrapper(HrOrgApproverRequest hrOrgApproverRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Integer orgApproverType = hrOrgApproverRequest.getOrgApproverType();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)orgApproverType), HrOrgApprover::getOrgApproverType, (Object)orgApproverType);
        Long orgId = hrOrgApproverRequest.getOrgId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)orgId), HrOrgApprover::getOrgId, (Object)orgId);
        Long userId = hrOrgApproverRequest.getUserId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userId), HrOrgApprover::getUserId, (Object)userId);
        return queryWrapper;
    }
}

