/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.position.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.util.BusinessLogUtil;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.sys.api.callback.RemovePositionCallbackApi;
import cn.stylefeng.roses.kernel.sys.modular.position.entity.HrPosition;
import cn.stylefeng.roses.kernel.sys.modular.position.enums.HrPositionExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.position.mapper.HrPositionMapper;
import cn.stylefeng.roses.kernel.sys.modular.position.pojo.request.HrPositionRequest;
import cn.stylefeng.roses.kernel.sys.modular.position.service.HrPositionService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HrPositionServiceImpl
extends ServiceImpl<HrPositionMapper, HrPosition>
implements HrPositionService {
    @Override
    public void add(HrPositionRequest hrPositionRequest) {
        HrPosition hrPosition = new HrPosition();
        BeanUtil.copyProperties((Object)((Object)hrPositionRequest), (Object)((Object)hrPosition), (String[])new String[0]);
        hrPosition.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.save((Object)hrPosition);
        BusinessLogUtil.setLogTitle((String)("\u65b0\u589e\u804c\u52a1\uff0c\u804c\u52a1\u540d\u79f0\uff1a" + hrPositionRequest.getPositionName()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u804c\u52a1\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a\n", hrPosition});
    }

    @Override
    public void del(HrPositionRequest hrPositionRequest) {
        this.baseDelete(CollectionUtil.set((boolean)false, (Object[])new Long[]{hrPositionRequest.getPositionId()}));
        HrPosition hrPosition = this.queryHrPosition(hrPositionRequest);
        this.removeById(hrPosition.getPositionId());
        BusinessLogUtil.setLogTitle((String)("\u5220\u9664\u804c\u52a1\uff0c\u804c\u52a1\u540d\u79f0\uff1a" + hrPosition.getPositionName()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u804c\u52a1\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a\n", hrPosition});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(HrPositionRequest hrPositionRequest) {
        Set<Long> positionIdList = hrPositionRequest.getPositionIdList();
        this.baseDelete(positionIdList);
        this.removeBatchByIds(positionIdList);
        BusinessLogUtil.setLogTitle((String)"\u6279\u91cf\u5220\u9664\u804c\u52a1", (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u88ab\u5220\u9664\u804c\u52a1\u4fe1\u606f\u5217\u8868\uff1a\n", positionIdList});
    }

    @Override
    public void edit(HrPositionRequest hrPositionRequest) {
        HrPosition hrPosition = this.queryHrPosition(hrPositionRequest);
        BusinessLogUtil.setLogTitle((String)"\u7f16\u8f91\u804c\u52a1\u4fe1\u606f\uff0c\u804c\u52a1\u540d\u79f0\uff1a", (String[])new String[]{hrPosition.getPositionName()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u539f\u59cb\u804c\u52a1\u4fe1\u606f\u5982\u4e0b\uff1a\n", hrPosition});
        BeanUtil.copyProperties((Object)((Object)hrPositionRequest), (Object)((Object)hrPosition), (String[])new String[0]);
        this.updateById((Object)hrPosition);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u65b0\u804c\u52a1\u4fe1\u606f\u5982\u4e0b\uff1a\n", hrPosition});
    }

    @Override
    public HrPosition detail(HrPositionRequest hrPositionRequest) {
        return this.queryHrPosition(hrPositionRequest);
    }

    @Override
    public PageResult<HrPosition> findPage(HrPositionRequest hrPositionRequest) {
        LambdaQueryWrapper<HrPosition> wrapper = this.createWrapper(hrPositionRequest);
        wrapper.select(new SFunction[]{HrPosition::getPositionId, HrPosition::getPositionName, HrPosition::getPositionCode, HrPosition::getRemark, HrPosition::getPositionSort, BaseEntity::getCreateTime});
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<SimpleDict> batchGetName(HrPositionRequest hrPositionRequest) {
        ArrayList<SimpleDict> dictList = new ArrayList<SimpleDict>();
        if (ObjectUtil.isEmpty((Object)((Object)hrPositionRequest)) || ObjectUtil.isEmpty(hrPositionRequest.getPositionIdList())) {
            return dictList;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(HrPosition::getPositionId, hrPositionRequest.getPositionIdList());
        wrapper.select(new SFunction[]{HrPosition::getPositionName, HrPosition::getPositionId});
        List list2 = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)list2)) {
            return dictList;
        }
        for (HrPosition hrPosition : list2) {
            dictList.add(new SimpleDict(hrPosition.getPositionId(), hrPosition.getPositionName(), null));
        }
        return dictList;
    }

    public String getPositionName(Long positionId) {
        if (positionId == null) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(HrPosition::getPositionId, (Object)positionId);
        queryWrapper.select(new SFunction[]{HrPosition::getPositionName});
        HrPosition hrPosition = (HrPosition)((Object)this.getOne((Wrapper)queryWrapper));
        if (hrPosition == null) {
            return null;
        }
        return hrPosition.getPositionName();
    }

    @Override
    public List<HrPosition> findList(HrPositionRequest hrPositionRequest) {
        LambdaQueryWrapper<HrPosition> wrapper = this.createWrapper(hrPositionRequest);
        wrapper.select(new SFunction[]{HrPosition::getPositionId, HrPosition::getPositionName, HrPosition::getPositionCode, HrPosition::getRemark, BaseEntity::getCreateTime});
        return this.list((Wrapper)wrapper);
    }

    private HrPosition queryHrPosition(HrPositionRequest hrPositionRequest) {
        HrPosition hrPosition = (HrPosition)((Object)this.getById(hrPositionRequest.getPositionId()));
        if (ObjectUtil.isEmpty((Object)((Object)hrPosition))) {
            throw new ServiceException((AbstractExceptionEnum)HrPositionExceptionEnum.HR_POSITION_NOT_EXISTED);
        }
        return hrPosition;
    }

    private LambdaQueryWrapper<HrPosition> createWrapper(HrPositionRequest hrPositionRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = hrPositionRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.like(HrPosition::getPositionName, (Object)searchText);
            ((LambdaQueryWrapper)queryWrapper.or()).like(HrPosition::getPositionCode, (Object)searchText);
        }
        queryWrapper.orderByAsc(HrPosition::getPositionSort);
        return queryWrapper;
    }

    private void baseDelete(Set<Long> positionIdList) {
        Map callbackApiMap = SpringUtil.getBeansOfType(RemovePositionCallbackApi.class);
        for (RemovePositionCallbackApi callbackApi : callbackApiMap.values()) {
            callbackApi.validateHavePositionBind(positionIdList);
        }
        for (RemovePositionCallbackApi callbackApi : callbackApiMap.values()) {
            callbackApi.removePositionAction(positionIdList);
        }
    }
}

