/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.log.api.util.BusinessLogUtil;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.SysRoleServiceApi;
import cn.stylefeng.roses.kernel.sys.api.enums.role.RoleTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserOrgDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.NewUserRoleBindItem;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.NewUserRoleBindResponse;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.request.DeleteRequest;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.request.RoleControlRequest;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.request.StatusControlRequest;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.request.SyncBindRequest;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUserOrg;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUserRole;
import cn.stylefeng.roses.kernel.sys.modular.user.enums.SysUserOrgExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.user.factory.RoleAssignFactory;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.request.SysUserOrgRequest;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysRoleAssignService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserOrgService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserRoleService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleAssignServiceImpl
implements SysRoleAssignService {
    @Resource
    private SysUserOrgService sysUserOrgService;
    @Resource
    private SysRoleServiceApi sysRoleServiceApi;
    @Resource
    private SysUserRoleService sysUserRoleService;
    @Resource(name="userRoleCache")
    private CacheOperatorApi<List<SysUserRole>> userRoleCache;

    @Override
    public List<NewUserRoleBindResponse> getUserAssignList(Long userId) {
        List userOrgList = this.sysUserOrgService.getUserOrgList(userId, true);
        if (ObjectUtil.isEmpty((Object)userOrgList)) {
            return new ArrayList<NewUserRoleBindResponse>();
        }
        List<NewUserRoleBindResponse> baseResponse = RoleAssignFactory.createBaseResponse(userOrgList);
        List businessRoleAndCompanyRole = this.sysRoleServiceApi.getBusinessRoleAndCompanyRole(userOrgList.stream().map(UserOrgDTO::getCompanyId).collect(Collectors.toList()));
        RoleAssignFactory.fillRoleSelectList(baseResponse, businessRoleAndCompanyRole);
        List userLinkedOrgRoleList = this.sysUserRoleService.getUserLinkedOrgRoleList(userId);
        return RoleAssignFactory.fillRoleBind(baseResponse, userLinkedOrgRoleList);
    }

    @Override
    public void changeUserBindStatus(StatusControlRequest statusControlRequest) {
        SysUserOrg userOrgInfo = this.sysUserOrgService.getUserOrgInfo(statusControlRequest.getUserId(), statusControlRequest.getOrgId());
        if (userOrgInfo == null) {
            throw new ServiceException((AbstractExceptionEnum)SysUserOrgExceptionEnum.SYS_USER_ORG_NOT_EXISTED);
        }
        if (statusControlRequest.getCheckedFlag().booleanValue()) {
            userOrgInfo.setStatusFlag(StatusEnum.ENABLE.getCode());
        } else {
            userOrgInfo.setStatusFlag(StatusEnum.DISABLE.getCode());
        }
        this.sysUserOrgService.updateById((Object)userOrgInfo);
    }

    @Override
    public void changeRoleSelect(RoleControlRequest roleControlRequest) {
        SysUserRole pointUserRole = this.sysUserRoleService.getPointUserRole(roleControlRequest.getUserId(), roleControlRequest.getRoleId(), roleControlRequest.getOrgId());
        if (pointUserRole != null && roleControlRequest.getCheckedFlag().booleanValue()) {
            return;
        }
        if (pointUserRole == null && roleControlRequest.getCheckedFlag().booleanValue()) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(roleControlRequest.getUserId());
            sysUserRole.setRoleId(roleControlRequest.getRoleId());
            sysUserRole.setRoleType(roleControlRequest.getRoleType());
            sysUserRole.setRoleOrgId(roleControlRequest.getOrgId());
            this.sysUserRoleService.save((Object)sysUserRole);
        } else if (pointUserRole != null) {
            this.sysUserRoleService.removeById(pointUserRole.getUserRoleId());
        }
        this.userRoleCache.remove(new String[]{String.valueOf(roleControlRequest.getUserId())});
        BusinessLogUtil.setLogTitle((String)"\u7ed1\u5b9a\u516c\u53f8\u6216\u4e1a\u52a1\u89d2\u8272", (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237id\uff1a", roleControlRequest.getUserId(), "\uff0c\u89d2\u8272id\uff1a", roleControlRequest.getRoleId(), "\uff0c\u89d2\u8272\u7c7b\u578b\uff1a", roleControlRequest.getRoleType(), "\uff0c\u673a\u6784id\uff1a", roleControlRequest.getOrgId(), "\uff0c\u7ed1\u5b9a\u72b6\u6001\uff1a", roleControlRequest.getCheckedFlag()});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeUserOrgBind(DeleteRequest deleteRequest) {
        this.sysUserOrgService.removeUserOrgLink(deleteRequest.getUserId(), deleteRequest.getOrgId());
        this.sysUserRoleService.removeUserOrgRoleLink(deleteRequest.getUserId(), deleteRequest.getOrgId());
        this.userRoleCache.remove(new String[]{String.valueOf(deleteRequest.getUserId())});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearAllOrgAndRoleBind(SysUserOrgRequest sysUserOrgRequest) {
        this.sysUserOrgService.deleteAllOrgBind(sysUserOrgRequest);
        this.sysUserRoleService.deleteUserAllOrgBind(sysUserOrgRequest.getUserId());
    }

    @Override
    public void disableAllOrgStatus(SysUserOrgRequest sysUserOrgRequest) {
        this.sysUserOrgService.disableAllOrgStatus(sysUserOrgRequest.getUserId());
    }

    @Override
    public void syncOtherOrgStatusAndBusinessRole(SyncBindRequest syncBindRequest) {
        Boolean statusFlag = syncBindRequest.getStatusFlag();
        this.sysUserOrgService.updateOtherOrgStatus(syncBindRequest.getUserId(), syncBindRequest.getOrgId(), statusFlag != false ? StatusEnum.ENABLE.getCode() : StatusEnum.DISABLE.getCode());
        List<NewUserRoleBindItem> currentOrgBindRoleList = syncBindRequest.getRoleBindItemList().stream().filter(i -> i.getRoleType().equals(RoleTypeEnum.BUSINESS_ROLE.getCode())).filter(NewUserRoleBindItem::getCheckedFlag).collect(Collectors.toList());
        this.sysUserRoleService.updateOtherOrgBusinessRole(syncBindRequest.getUserId(), syncBindRequest.getOrgId(), currentOrgBindRoleList);
    }
}

