/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.event.sdk.publish.BusinessEventPublisher;
import cn.stylefeng.roses.kernel.log.api.util.BusinessLogUtil;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.SysRoleLimitServiceApi;
import cn.stylefeng.roses.kernel.sys.api.SysRoleServiceApi;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveRoleCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveUserCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.constants.SysConstants;
import cn.stylefeng.roses.kernel.sys.api.enums.role.RoleTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.NewUserRoleBindItem;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.UserRoleDTO;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUserRole;
import cn.stylefeng.roses.kernel.sys.modular.user.enums.SysUserExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.user.mapper.SysUserRoleMapper;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.request.SysUserRoleRequest;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserOrgService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserRoleService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserRoleServiceImpl
extends ServiceImpl<SysUserRoleMapper, SysUserRole>
implements SysUserRoleService,
RemoveUserCallbackApi,
RemoveRoleCallbackApi {
    @Resource
    private SysRoleServiceApi sysRoleServiceApi;
    @Resource
    private SysUserService sysUserService;
    @Resource(name="userRoleCache")
    private CacheOperatorApi<List<SysUserRole>> userRoleCache;
    @Resource
    private SysRoleLimitServiceApi sysRoleLimitServiceApi;
    @Resource
    private SysUserOrgService sysUserOrgService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindRoles(SysUserRoleRequest sysUserRoleRequest) {
        boolean userSuperAdminFlag = this.sysUserService.getUserSuperAdminFlag(sysUserRoleRequest.getUserId());
        if (userSuperAdminFlag) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.CANT_CHANGE_ADMIN_ROLE);
        }
        boolean superAdminFlag = LoginContext.me().getSuperAdminFlag();
        if (!superAdminFlag) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.CANT_CHANGE_BASE_SYSTEM_ROLE);
        }
        this.removeRoleAlreadyBind(sysUserRoleRequest);
        Set<Long> roleIdList = sysUserRoleRequest.getRoleIdList();
        List<SysUserRole> newUserRoles = this.createUserSystemRoleBinds(sysUserRoleRequest, roleIdList);
        this.saveBatch(newUserRoles);
        BusinessEventPublisher.publishEvent((String)"UPDATE_USER_ROLE_EVENT", (Object)sysUserRoleRequest.getUserId());
        BusinessLogUtil.setLogTitle((String)"\u4e3a\u7528\u6237\u7ed1\u5b9a\u89d2\u8272\uff0c\u7528\u6237\u8d26\u53f7\uff1a", (String[])new String[]{this.sysUserService.getUserRealName(sysUserRoleRequest.getUserId())});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237id\uff1a\n", sysUserRoleRequest.getUserId()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237\u89d2\u8272\u4fe1\u606f\u5982\u4e0b\uff1a\n", roleIdList});
    }

    @Override
    public void bindUserDefaultRole(Long userId) {
        Long defaultRoleId = this.sysRoleServiceApi.getDefaultRoleId();
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(userId);
        sysUserRole.setRoleId(defaultRoleId);
        this.save((Object)sysUserRole);
        BusinessEventPublisher.publishEvent((String)"UPDATE_USER_ROLE_EVENT", (Object)userId);
    }

    public void validateHaveUserBind(Set<Long> beRemovedUserIdList) {
    }

    public void removeUserAction(Set<Long> beRemovedUserIdList) {
        LambdaQueryWrapper sysUserRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserRoleLambdaQueryWrapper.in(SysUserRole::getUserId, beRemovedUserIdList);
        this.remove((Wrapper)sysUserRoleLambdaQueryWrapper);
    }

    public void validateHaveRoleBind(Set<Long> beRemovedRoleIdList) {
    }

    public void removeRoleAction(Set<Long> beRemovedRoleIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysUserRole::getRoleId, beRemovedRoleIdList);
        this.remove((Wrapper)wrapper);
    }

    public List<Long> getUserRoleIdList(Long userId) {
        if (userId == null) {
            return new ArrayList<Long>();
        }
        List cachedRoleList = (List)this.userRoleCache.get(userId.toString());
        if (ObjectUtil.isNotEmpty((Object)cachedRoleList)) {
            return cachedRoleList.stream().map(SysUserRole::getRoleId).collect(Collectors.toList());
        }
        List<SysUserRole> sysUserRoleList = this.dbGetUserTotalRoleList(userId);
        if (ObjectUtil.isNotEmpty(sysUserRoleList)) {
            this.userRoleCache.put(userId.toString(), sysUserRoleList, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        }
        return sysUserRoleList.stream().map(SysUserRole::getRoleId).collect(Collectors.toList());
    }

    public Set<Long> getUserSystemRoleIdList(Long userId) {
        if (userId == null) {
            return new LinkedHashSet<Long>();
        }
        List cachedRoleList = (List)this.userRoleCache.get(userId.toString());
        if (ObjectUtil.isNotEmpty((Object)cachedRoleList)) {
            return cachedRoleList.stream().filter(i -> RoleTypeEnum.SYSTEM_ROLE.getCode().equals(i.getRoleType())).map(SysUserRole::getRoleId).collect(Collectors.toSet());
        }
        List<SysUserRole> sysUserRoleList = this.dbGetUserTotalRoleList(userId);
        if (ObjectUtil.isNotEmpty(sysUserRoleList)) {
            this.userRoleCache.put(userId.toString(), sysUserRoleList, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        }
        return sysUserRoleList.stream().filter(i -> RoleTypeEnum.SYSTEM_ROLE.getCode().equals(i.getRoleType())).map(SysUserRole::getRoleId).collect(Collectors.toSet());
    }

    public List<UserRoleDTO> getUserLinkedOrgRoleList(Long userId) {
        List cachedRoleList = (List)this.userRoleCache.get(userId.toString());
        if (ObjectUtil.isNotEmpty((Object)cachedRoleList)) {
            List result = cachedRoleList.stream().filter(i -> ObjectUtil.isNotEmpty((Object)i.getRoleOrgId())).collect(Collectors.toList());
            return BeanUtil.copyToList(result, UserRoleDTO.class);
        }
        List<SysUserRole> sysUserRoleList = this.dbGetUserTotalRoleList(userId);
        if (ObjectUtil.isNotEmpty(sysUserRoleList)) {
            this.userRoleCache.put(userId.toString(), sysUserRoleList, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        }
        List finalResult = sysUserRoleList.stream().filter(i -> ObjectUtil.isNotEmpty((Object)i.getRoleOrgId())).collect(Collectors.toList());
        return BeanUtil.copyToList(finalResult, UserRoleDTO.class);
    }

    public List<Long> getUserRoleIdListCurrentCompany(Long userId, Long orgId) {
        List cachedRoleList = (List)this.userRoleCache.get(userId.toString());
        if (ObjectUtil.isNotEmpty((Object)cachedRoleList)) {
            return this.getUserCompanyPermissionRole(cachedRoleList, orgId);
        }
        List<SysUserRole> sysUserRoleList = this.dbGetUserTotalRoleList(userId);
        if (ObjectUtil.isNotEmpty(sysUserRoleList)) {
            this.userRoleCache.put(userId.toString(), sysUserRoleList, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        }
        return this.getUserCompanyPermissionRole(sysUserRoleList, orgId);
    }

    public List<Long> findUserIdsByRoleId(Long roleId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserRole::getRoleId, (Object)roleId);
        queryWrapper.select(new SFunction[]{SysUserRole::getUserId});
        List list2 = this.list((Wrapper)queryWrapper);
        return list2.stream().map(SysUserRole::getUserId).collect(Collectors.toList());
    }

    public Set<Long> findUserRoleLimitScope(Long userId) {
        List<Long> userRoleIdList = this.getUserRoleIdList(userId);
        return this.sysRoleLimitServiceApi.getRoleBindLimitList(userRoleIdList);
    }

    public Set<Long> findCurrentUserRoleLimitScope() {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        return this.findUserRoleLimitScope(userId);
    }

    public void removeUserOrgRoleLink(Long userId, Long orgId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserRole::getUserId, (Object)userId);
        queryWrapper.eq(SysUserRole::getRoleOrgId, (Object)orgId);
        this.remove((Wrapper)queryWrapper);
    }

    public void deleteUserAllOrgBind(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserRole::getUserId, (Object)userId);
        queryWrapper.isNotNull(SysUserRole::getRoleOrgId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public SysUserRole getPointUserRole(Long userId, Long roleId, Long orgId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserRole::getUserId, (Object)userId);
        queryWrapper.eq(SysUserRole::getRoleId, (Object)roleId);
        queryWrapper.eq(SysUserRole::getRoleOrgId, (Object)orgId);
        queryWrapper.select(new SFunction[]{SysUserRole::getUserRoleId, SysUserRole::getUserId, SysUserRole::getRoleId, SysUserRole::getRoleType, SysUserRole::getRoleOrgId});
        return (SysUserRole)((Object)this.getOne((Wrapper)queryWrapper, false));
    }

    @Override
    public void addBusinessAndCompanyBindRole(SysUserRole sysUserRole) {
        if (sysUserRole == null) {
            return;
        }
        Integer roleType = sysUserRole.getRoleType();
        if (!RoleTypeEnum.BUSINESS_ROLE.getCode().equals(roleType) || !RoleTypeEnum.COMPANY_ROLE.getCode().equals(roleType)) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.ROLE_TYPE_PERMISSION_ERROR);
        }
        Long roleOrgId = sysUserRole.getRoleOrgId();
        if (ObjectUtil.isEmpty((Object)roleOrgId)) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.ORG_ID_EMPTY_ERROR);
        }
        this.save((Object)sysUserRole);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOtherOrgBusinessRole(Long userId, Long excludeOrgId, List<NewUserRoleBindItem> currentOrgBindRoleList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserRole::getUserId, (Object)userId);
        queryWrapper.eq(SysUserRole::getRoleType, (Object)RoleTypeEnum.BUSINESS_ROLE.getCode());
        queryWrapper.ne(SysUserRole::getRoleOrgId, (Object)excludeOrgId);
        this.remove((Wrapper)queryWrapper);
        this.userRoleCache.remove(new String[]{userId.toString()});
        List userOrgIdList = this.sysUserOrgService.getUserOrgIdList(userId, true);
        if (ObjectUtil.isEmpty((Object)userOrgIdList)) {
            return;
        }
        List excludeAfterOrgIds = userOrgIdList.stream().filter(orgId -> !orgId.equals(excludeOrgId)).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(excludeAfterOrgIds)) {
            return;
        }
        if (ObjectUtil.isEmpty(currentOrgBindRoleList)) {
            return;
        }
        ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
        for (Long userOrgId : excludeAfterOrgIds) {
            for (NewUserRoleBindItem newUserRoleBindItem : currentOrgBindRoleList) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setRoleId(newUserRoleBindItem.getRoleId());
                sysUserRole.setRoleType(RoleTypeEnum.BUSINESS_ROLE.getCode());
                sysUserRole.setRoleOrgId(userOrgId);
                sysUserRoles.add(sysUserRole);
            }
        }
        this.saveBatch(sysUserRoles);
        this.userRoleCache.remove(new String[]{userId.toString()});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void quickBatchSaveUserRole(List<SysUserRole> batchUserRole) {
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((SysUserRoleMapper)this.getBaseMapper()).insertBatchSomeColumn(batchUserRole);
        } else {
            this.saveBatch(batchUserRole);
        }
    }

    private void removeRoleAlreadyBind(SysUserRoleRequest sysUserRoleRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserRole::getUserId, (Object)sysUserRoleRequest.getUserId());
        queryWrapper.eq(SysUserRole::getRoleType, (Object)RoleTypeEnum.SYSTEM_ROLE.getCode());
        this.remove((Wrapper)queryWrapper);
    }

    private List<SysUserRole> dbGetUserTotalRoleList(Long userId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUserRole::getUserId, (Object)userId);
        wrapper.select(new SFunction[]{SysUserRole::getRoleId, SysUserRole::getRoleOrgId, SysUserRole::getRoleType});
        return this.list((Wrapper)wrapper);
    }

    private List<Long> getUserCompanyPermissionRole(List<SysUserRole> paramRoles, Long userCurrentOrgId) {
        Set baseRoleIdList = paramRoles.stream().filter(i -> RoleTypeEnum.SYSTEM_ROLE.getCode().equals(i.getRoleType()) && i.getRoleOrgId() == null).map(SysUserRole::getRoleId).collect(Collectors.toSet());
        if (ObjectUtil.isEmpty((Object)userCurrentOrgId)) {
            return new ArrayList<Long>(baseRoleIdList);
        }
        Set currentCompanyRoleIdList = paramRoles.stream().filter(i -> i.getRoleOrgId() != null && i.getRoleOrgId().equals(userCurrentOrgId)).map(SysUserRole::getRoleId).collect(Collectors.toSet());
        ArrayList<Long> resultRoleIdList = new ArrayList<Long>();
        if (ObjectUtil.isNotEmpty(baseRoleIdList)) {
            resultRoleIdList.addAll(baseRoleIdList);
        }
        if (ObjectUtil.isNotEmpty(currentCompanyRoleIdList)) {
            resultRoleIdList.addAll(currentCompanyRoleIdList);
        }
        return resultRoleIdList;
    }

    private List<SysUserRole> createUserSystemRoleBinds(SysUserRoleRequest sysUserRoleRequest, Set<Long> roleIdList) {
        ArrayList<SysUserRole> newUserRoles = new ArrayList<SysUserRole>();
        for (Long newRoleId : roleIdList) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(sysUserRoleRequest.getUserId());
            sysUserRole.setRoleId(newRoleId);
            sysUserRole.setRoleType(RoleTypeEnum.SYSTEM_ROLE.getCode());
            newUserRoles.add(sysUserRole);
        }
        return newUserRoles;
    }
}

