/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.auth.api.TenantCodeGetApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.password.SaltedEncryptResult;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.db.mp.tenant.holder.TenantIdHolder;
import cn.stylefeng.roses.kernel.db.mp.tenant.holder.TenantSwitchHolder;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.file.api.FileInfoApi;
import cn.stylefeng.roses.kernel.file.api.constants.FileConstants;
import cn.stylefeng.roses.kernel.log.api.util.BusinessLogUtil;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.rule.util.SortUtils;
import cn.stylefeng.roses.kernel.sys.api.SecurityConfigService;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveUserCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.enums.user.UserStatusEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.AddUserDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.OnlineUserItem;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.SimpleUserDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.TempLoginUserInfo;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserInfoDetailDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserValidateDTO;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUser;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUserOrg;
import cn.stylefeng.roses.kernel.sys.modular.user.enums.SysUserExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.user.factory.SysUserCreateFactory;
import cn.stylefeng.roses.kernel.sys.modular.user.factory.UserDataScopeFactory;
import cn.stylefeng.roses.kernel.sys.modular.user.mapper.SysUserMapper;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.request.SysUserRequest;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.response.PersonalInfo;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.response.SysUserCertificateResponse;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserCertificateService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserOrgService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserRoleService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements SysUserService {
    @Resource
    private PasswordStoredEncryptApi passwordStoredEncryptApi;
    @Resource
    private SysUserOrgService sysUserOrgService;
    @Resource
    private SysUserRoleService sysUserRoleService;
    @Resource
    private FileInfoApi fileInfoApi;
    @Resource
    private TenantCodeGetApi tenantCodeGetApi;
    @Resource(name="loginErrorCountCacheApi")
    private CacheOperatorApi<Integer> loginErrorCountCacheApi;
    @Resource
    private SecurityConfigService securityConfigService;
    @Resource
    private SysUserCertificateService sysUserCertificateService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SysUserRequest sysUserRequest) {
        SysUser sysUser = new SysUser();
        BeanUtil.copyProperties((Object)((Object)sysUserRequest), (Object)((Object)sysUser), (String[])new String[0]);
        String password = sysUserRequest.getPassword().trim();
        this.securityConfigService.validatePasswordSecurityRule(false, password);
        SaltedEncryptResult saltedEncryptResult = this.passwordStoredEncryptApi.encryptWithSalt(password);
        sysUser.setPassword(saltedEncryptResult.getEncryptPassword());
        sysUser.setPasswordSalt(saltedEncryptResult.getPasswordSalt());
        sysUser.setAvatar(FileConstants.DEFAULT_AVATAR_FILE_ID);
        this.save((Object)sysUser);
        this.securityConfigService.recordPasswordEditLog(sysUser.getUserId(), saltedEncryptResult.getEncryptPassword(), saltedEncryptResult.getPasswordSalt());
        this.sysUserOrgService.updateUserOrg(sysUser.getUserId(), sysUserRequest.getUserOrgList());
        this.sysUserRoleService.bindUserDefaultRole(sysUser.getUserId());
        this.sysUserCertificateService.updateUserCertificate(sysUser.getUserId(), sysUserRequest.getUserCertificateList());
        BusinessLogUtil.setLogTitle((String)("\u65b0\u589e\u7528\u6237\uff0c\u7528\u6237\u8d26\u53f7\uff1a" + sysUser.getAccount()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u65b0\u589e\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff1a", sysUser.getAccount()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a\n", sysUser});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysUserRequest sysUserRequest) {
        SysUser sysUser = this.querySysUser(sysUserRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysUser.getSuperAdminFlag())) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.USER_CAN_NOT_DELETE_ADMIN);
        }
        this.baseRemoveUser(CollectionUtil.set((boolean)false, (Object[])new Long[]{sysUser.getUserId()}));
        BusinessLogUtil.setLogTitle((String)("\u5220\u9664\u7528\u6237\uff0c\u7528\u6237\u8d26\u53f7\uff1a" + sysUser.getAccount()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237\u8d26\u53f7\uff1a", sysUser.getAccount()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\uff1a\n", sysUser});
    }

    @Override
    public void batchDel(SysUserRequest sysUserRequest) {
        Set<Long> userIdList = sysUserRequest.getUserIdList();
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.in(SysUser::getUserId, userIdList);
        sysUserLambdaQueryWrapper.eq(SysUser::getSuperAdminFlag, (Object)YesOrNotEnum.Y.getCode());
        long adminCount = this.count((Wrapper)sysUserLambdaQueryWrapper);
        if (adminCount > 0L) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.USER_CAN_NOT_DELETE_ADMIN);
        }
        this.baseRemoveUser(userIdList);
        BusinessLogUtil.setLogTitle((String)"\u6279\u91cf\u5220\u9664\u7528\u6237", (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237id\u96c6\u5408\u4e3a\uff1a\n", userIdList});
    }

    @Override
    public void edit(SysUserRequest sysUserRequest) {
        SysUser sysUser = this.querySysUser(sysUserRequest);
        BusinessLogUtil.setLogTitle((String)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\uff0c\u7528\u6237\u8d26\u53f7\uff1a" + sysUser.getAccount()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u539f\u59cb\u7528\u6237\u4fe1\u606f\u5982\u4e0b\uff1a\n", sysUser});
        if ("admin".equals(sysUser.getAccount())) {
            if (!sysUser.getAccount().equals(sysUserRequest.getAccount())) {
                throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.CANT_CHANGE_ADMIN_ACCOUNT);
            }
            if (YesOrNotEnum.N.getCode().equals(sysUserRequest.getSuperAdminFlag())) {
                throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.CANT_CHANGE_ADMIN_FLAG);
            }
        }
        BeanUtil.copyProperties((Object)((Object)sysUserRequest), (Object)((Object)sysUser), (String[])new String[0]);
        sysUser.setPassword(null);
        this.updateById((Object)sysUser);
        this.sysUserOrgService.updateUserOrg(sysUser.getUserId(), sysUserRequest.getUserOrgList());
        this.sysUserCertificateService.updateUserCertificate(sysUser.getUserId(), sysUserRequest.getUserCertificateList());
        BusinessLogUtil.addContent((Object[])new Object[]{"\u66f4\u65b0\u540e\u7528\u6237\u4fe1\u606f\u5982\u4e0b\uff1a\n", sysUser});
    }

    @Override
    public SysUser detail(SysUserRequest sysUserRequest) {
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)sysUserRequest.getUserId());
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getUserId, SysUser::getAvatar, SysUser::getAccount, SysUser::getUserSort, SysUser::getSuperAdminFlag, SysUser::getRealName, SysUser::getSex, SysUser::getBirthday, SysUser::getEmail, SysUser::getPhone, SysUser::getLastLoginIp, SysUser::getLoginCount, SysUser::getLastLoginTime, SysUser::getStatusFlag, BaseEntity::getCreateTime, BaseEntity::getUpdateTime, SysUser::getEmployeeNumber});
        SysUser sysUser = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper, false));
        List userOrgList = this.sysUserOrgService.getUserOrgList(sysUser.getUserId(), true);
        sysUser.setUserOrgDTOList(userOrgList);
        Set userRoleIdList = this.sysUserRoleService.getUserSystemRoleIdList(sysUser.getUserId());
        sysUser.setRoleIdList(new ArrayList<Long>(userRoleIdList));
        List<SysUserCertificateResponse> userCertificateList = this.sysUserCertificateService.getUserCertificateList(sysUser.getUserId());
        sysUser.setUserCertificateList(userCertificateList);
        return sysUser;
    }

    @Override
    public List<SysUser> findList(SysUserRequest sysUserRequest) {
        LambdaQueryWrapper<SysUser> wrapper = this.createWrapper(sysUserRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public PageResult<SysUser> findPage(SysUserRequest sysUserRequest) {
        LambdaQueryWrapper<SysUser> wrapper = this.createWrapper(sysUserRequest);
        wrapper.select(new SFunction[]{SysUser::getUserId, SysUser::getRealName, SysUser::getAccount, SysUser::getSex, SysUser::getStatusFlag, BaseEntity::getCreateTime, SysUser::getEmployeeNumber});
        Page sysUserPage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        for (SysUser record : sysUserPage.getRecords()) {
            record.setUserOrgDTO(this.sysUserOrgService.getUserMainOrgInfo(record.getUserId()));
        }
        return PageResultFactory.createPageResult((Page)sysUserPage);
    }

    @Override
    public void updateStatus(SysUserRequest sysUserRequest) {
        boolean userSuperAdminFlag = this.getUserSuperAdminFlag(sysUserRequest.getUserId());
        if (userSuperAdminFlag) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.CANT_UPDATE_STATUS);
        }
        Integer statusFlag = sysUserRequest.getStatusFlag();
        UserStatusEnum.validateUserStatus((Integer)statusFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SysUser::getStatusFlag, (Object)sysUserRequest.getStatusFlag());
        updateWrapper.eq(SysUser::getUserId, (Object)sysUserRequest.getUserId());
        this.update((Wrapper)updateWrapper);
        if (statusFlag.equals(UserStatusEnum.ENABLE.getCode())) {
            Long userId = sysUserRequest.getUserId();
            LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
            sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)userId);
            sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getAccount});
            SysUser sysUser = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper));
            if (sysUser != null) {
                this.loginErrorCountCacheApi.remove(new String[]{sysUser.getAccount()});
            }
        }
        BusinessLogUtil.setLogTitle((String)("\u66f4\u65b0\u7528\u6237\u72b6\u6001\uff0c\u7528\u6237\u8d26\u53f7\uff1a" + this.getUserRealName(sysUserRequest.getUserId())), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237id\uff1a", sysUserRequest.getUserId()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u4fee\u6539\u72b6\u6001\u4e3a\uff1a", sysUserRequest.getStatusFlag()});
    }

    public void resetPassword(Long userId, String newPassword) {
        SysUser sysUser = (SysUser)((Object)this.getById(userId));
        SaltedEncryptResult saltedEncryptResult = this.passwordStoredEncryptApi.encryptWithSalt(newPassword);
        sysUser.setPassword(saltedEncryptResult.getEncryptPassword());
        sysUser.setPasswordSalt(saltedEncryptResult.getPasswordSalt());
        this.updateById((Object)sysUser);
        BusinessLogUtil.setLogTitle((String)("\u91cd\u7f6e\u7528\u6237\u5bc6\u7801\uff0c\u7528\u6237\u8d26\u53f7\uff1a" + sysUser.getRealName()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237\u4fe1\u606f\u5982\u4e0b\uff1a\n", sysUser});
    }

    @Override
    public PersonalInfo getPersonalInfo() {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)userId);
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getRealName, SysUser::getAccount, SysUser::getAvatar, SysUser::getEmail, SysUser::getPhone, SysUser::getSex, SysUser::getBirthday});
        SysUser sysUser = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper, false));
        if (sysUser == null) {
            return new PersonalInfo();
        }
        PersonalInfo personalInfo = new PersonalInfo();
        BeanUtil.copyProperties((Object)((Object)sysUser), (Object)personalInfo, (String[])new String[0]);
        return personalInfo;
    }

    @Override
    public void editInfo(SysUserRequest sysUserRequest) {
        sysUserRequest.setUserId(LoginContext.me().getLoginUser().getUserId());
        SysUser sysUser = this.querySysUser(sysUserRequest);
        SysUserCreateFactory.fillUpdateInfo(sysUserRequest, sysUser);
        this.updateById((Object)sysUser);
    }

    @Override
    public void editPassword(SysUserRequest sysUserRequest) {
        if (sysUserRequest.getNewPassword().equals(sysUserRequest.getPassword())) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.USER_PWD_REPEAT);
        }
        LoginUser loginUser = LoginContext.me().getLoginUser();
        sysUserRequest.setUserId(loginUser.getUserId());
        SysUser sysUser = this.querySysUser(sysUserRequest);
        if (!this.passwordStoredEncryptApi.checkPasswordWithSalt(sysUserRequest.getPassword(), sysUser.getPasswordSalt(), sysUser.getPassword()).booleanValue()) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.USER_PWD_ERROR);
        }
        String password = sysUserRequest.getNewPassword().trim();
        this.securityConfigService.validatePasswordSecurityRule(true, password);
        SaltedEncryptResult saltedEncryptResult = this.passwordStoredEncryptApi.encryptWithSalt(password);
        sysUser.setPassword(saltedEncryptResult.getEncryptPassword());
        sysUser.setPasswordSalt(saltedEncryptResult.getPasswordSalt());
        this.updateById((Object)sysUser);
        this.securityConfigService.recordPasswordEditLog(sysUser.getUserId(), saltedEncryptResult.getEncryptPassword(), saltedEncryptResult.getPasswordSalt());
        BusinessLogUtil.setLogTitle((String)("\u4fee\u6539\u5bc6\u7801\uff0c\u8d26\u53f7\uff1a" + loginUser.getAccount()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237\u8d26\u53f7\uff1a" + loginUser.getAccount() + "\u4fee\u6539\u4e86\u5bc6\u7801"});
    }

    @Override
    public List<SimpleDict> batchGetName(SysUserRequest sysUserRequest) {
        ArrayList<SimpleDict> dictList = new ArrayList<SimpleDict>();
        if (ObjectUtil.isEmpty((Object)((Object)sysUserRequest)) || ObjectUtil.isEmpty(sysUserRequest.getUserIdList())) {
            return dictList;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysUser::getUserId, sysUserRequest.getUserIdList());
        wrapper.select(new SFunction[]{SysUser::getRealName, SysUser::getUserId});
        List list2 = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)list2)) {
            return dictList;
        }
        List sortUsers = SortUtils.sortListByObjectKey((List)list2, new LinkedList<Long>(sysUserRequest.getUserIdList()));
        for (SysUser sysUser : sortUsers) {
            dictList.add(new SimpleDict(sysUser.getUserId(), sysUser.getRealName(), null));
        }
        return dictList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void quickBatchSaveUser(List<SysUser> batchUser) {
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((SysUserMapper)this.getBaseMapper()).insertBatchSomeColumn(batchUser);
        } else {
            this.saveBatch(batchUser);
        }
    }

    @Override
    public void editAvatar(SysUserRequest sysUserRequest) {
        Long fileId = sysUserRequest.getAvatar();
        LoginUser loginUser = LoginContext.me().getLoginUser();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysUser::getUserId, (Object)loginUser.getUserId());
        wrapper.set(SysUser::getAvatar, (Object)fileId);
        this.update((Wrapper)wrapper);
    }

    public SimpleUserDTO getUserInfoByUserId(Long userId) {
        if (ObjectUtil.isEmpty((Object)userId)) {
            return null;
        }
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)userId);
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getRealName, SysUser::getAvatar, SysUser::getAccount});
        SysUser sysUser = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper));
        if (sysUser == null) {
            return null;
        }
        SimpleUserDTO simpleUserDTO = new SimpleUserDTO();
        simpleUserDTO.setUserId(userId);
        simpleUserDTO.setRealName(sysUser.getRealName());
        simpleUserDTO.setAccount(sysUser.getAccount());
        Long avatarFileId = sysUser.getAvatar();
        if (avatarFileId != null) {
            String fileAuthUrl = this.fileInfoApi.getFileAuthUrl(avatarFileId);
            simpleUserDTO.setAvatarUrl(fileAuthUrl);
        }
        return simpleUserDTO;
    }

    @Cacheable(value={"users"}, key="#userId", unless="#result.length() == 0")
    public String getUserRealName(Long userId) {
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getRealName});
        sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)userId);
        SysUser sysUser = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper));
        if (sysUser == null) {
            return "";
        }
        return sysUser.getRealName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserValidateDTO getUserLoginValidateDTO(Long tenantId, String account) {
        SysUser sysUserServiceOne;
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.eq(SysUser::getAccount, (Object)account);
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getPassword, SysUser::getPasswordSalt, SysUser::getStatusFlag, SysUser::getFreezeDeadlineTime, SysUser::getUserId});
        try {
            TenantIdHolder.set((Long)tenantId);
            sysUserServiceOne = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper, false));
            if (sysUserServiceOne == null) {
                throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.ACCOUNT_NOT_EXIST);
            }
            this.updateSysUserFreezeStatus(account, sysUserServiceOne);
        }
        finally {
            TenantIdHolder.remove();
        }
        return new UserValidateDTO(sysUserServiceOne.getUserId(), sysUserServiceOne.getPassword(), sysUserServiceOne.getPasswordSalt(), sysUserServiceOne.getStatusFlag(), tenantId, account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserValidateDTO getUserLoginValidateDTO(Long userId) {
        SysUser sysUser;
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)userId);
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getPassword, SysUser::getAccount, SysUser::getPasswordSalt, SysUser::getStatusFlag, SysUser::getUserId, SysUser::getTenantId});
        try {
            TenantSwitchHolder.set((Boolean)false);
            sysUser = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper, false));
        }
        finally {
            TenantSwitchHolder.remove();
        }
        if (sysUser == null) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.ACCOUNT_NOT_EXIST);
        }
        return new UserValidateDTO(sysUser.getUserId(), sysUser.getPassword(), sysUser.getPasswordSalt(), sysUser.getStatusFlag(), sysUser.getTenantId(), sysUser.getAccount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserLoginInfo(Long userId, String ip, Long tenantId) {
        SysUser originUser;
        if (ObjectUtil.isEmpty((Object)userId) || ObjectUtil.isEmpty((Object)ip)) {
            return;
        }
        long loginCount = 0L;
        LambdaQueryWrapper sysUserOriginLoginCountWrapper = new LambdaQueryWrapper();
        sysUserOriginLoginCountWrapper.eq(SysUser::getUserId, (Object)userId);
        sysUserOriginLoginCountWrapper.select(new SFunction[]{SysUser::getLoginCount});
        try {
            TenantIdHolder.set((Long)tenantId);
            originUser = (SysUser)((Object)this.getOne((Wrapper)sysUserOriginLoginCountWrapper, false));
        }
        finally {
            TenantIdHolder.remove();
        }
        loginCount = originUser == null || originUser.getLoginCount() == null ? 1L : (long)(originUser.getLoginCount() + 1);
        LambdaUpdateWrapper sysUserLambdaUpdateWrapper = new LambdaUpdateWrapper();
        sysUserLambdaUpdateWrapper.eq(SysUser::getUserId, (Object)userId);
        sysUserLambdaUpdateWrapper.set(SysUser::getLastLoginTime, (Object)new Date());
        sysUserLambdaUpdateWrapper.set(SysUser::getLastLoginIp, (Object)ip);
        sysUserLambdaUpdateWrapper.set(SysUser::getLoginCount, (Object)loginCount);
        try {
            TenantIdHolder.set((Long)tenantId);
            this.update((Wrapper)sysUserLambdaUpdateWrapper);
        }
        finally {
            TenantIdHolder.remove();
        }
    }

    public boolean getUserSuperAdminFlag(Long userId) {
        if (ObjectUtil.isEmpty((Object)userId)) {
            return false;
        }
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)userId);
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getSuperAdminFlag});
        SysUser result = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper, false));
        if (result == null) {
            return false;
        }
        return YesOrNotEnum.Y.getCode().equals(result.getSuperAdminFlag());
    }

    public List<Long> queryAllUserIdList() {
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getUserId});
        List list2 = this.list((Wrapper)sysUserLambdaQueryWrapper);
        return list2.stream().map(SysUser::getUserId).collect(Collectors.toList());
    }

    public Boolean userExist(Long userId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUser::getUserId, (Object)userId);
        long count = this.count((Wrapper)wrapper);
        return count > 0L;
    }

    public OnlineUserItem getUserNameAccountInfo(Long userId) {
        if (userId == null) {
            return new OnlineUserItem();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUser::getUserId, (Object)userId);
        wrapper.select(new SFunction[]{SysUser::getRealName, SysUser::getAccount});
        SysUser sysUser = (SysUser)((Object)this.getOne((Wrapper)wrapper, false));
        if (sysUser != null) {
            return new OnlineUserItem(userId, sysUser.getRealName(), sysUser.getAccount());
        }
        return new OnlineUserItem();
    }

    public List<OnlineUserItem> getUserNameAccountInfoListByCondition(List<OnlineUserItem> onlineUserItems, String searchText) {
        if (ObjectUtil.isEmpty(onlineUserItems) || ObjectUtil.isEmpty((Object)searchText)) {
            return new ArrayList<OnlineUserItem>();
        }
        Set userIdList = onlineUserItems.stream().map(OnlineUserItem::getUserId).collect(Collectors.toSet());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysUser::getUserId, userIdList);
        wrapper.nested(wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrap.like(SysUser::getRealName, (Object)searchText)).or()).like(SysUser::getAccount, (Object)searchText));
        wrapper.select(new SFunction[]{SysUser::getUserId, SysUser::getRealName, SysUser::getAccount});
        List sysUserList = this.list((Wrapper)wrapper);
        ArrayList<OnlineUserItem> resultList = new ArrayList<OnlineUserItem>();
        if (ObjectUtil.isEmpty((Object)sysUserList)) {
            return resultList;
        }
        Map<Long, SysUser> userMap = sysUserList.stream().collect(Collectors.toMap(SysUser::getUserId, item -> item));
        for (OnlineUserItem onlineUserItem : onlineUserItems) {
            SysUser sysUser = userMap.get(onlineUserItem.getUserId());
            if (sysUser == null) continue;
            onlineUserItem.setRealName(sysUser.getRealName());
            onlineUserItem.setAccount(sysUser.getAccount());
            resultList.add(onlineUserItem);
        }
        return resultList;
    }

    public UserInfoDetailDTO getUserDetail(Long userId) {
        UserInfoDetailDTO result = new UserInfoDetailDTO();
        if (ObjectUtil.isEmpty((Object)userId)) {
            return result;
        }
        LambdaQueryWrapper sysUserLambdaQueryWrapper = new LambdaQueryWrapper();
        sysUserLambdaQueryWrapper.eq(SysUser::getUserId, (Object)userId);
        sysUserLambdaQueryWrapper.select(new SFunction[]{SysUser::getUserId, SysUser::getRealName, SysUser::getNickName, SysUser::getAccount, SysUser::getBirthday, SysUser::getSex, SysUser::getPhone, SysUser::getTel, SysUser::getEmail, SysUser::getSuperAdminFlag, SysUser::getStatusFlag, SysUser::getUserSort, SysUser::getMasterUserId});
        SysUser userInfo = (SysUser)((Object)this.getOne((Wrapper)sysUserLambdaQueryWrapper));
        if (userInfo != null) {
            BeanUtil.copyProperties((Object)((Object)userInfo), (Object)result, (String[])new String[0]);
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockUserStatus(String tenantCode, String account) {
        Long tenantId = this.tenantCodeGetApi.getTenantIdByCode(tenantCode);
        try {
            TenantIdHolder.set((Long)tenantId);
            LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
            lambdaUpdateWrapper.eq(SysUser::getAccount, (Object)account);
            lambdaUpdateWrapper.set(SysUser::getStatusFlag, UserStatusEnum.TEMP_FREEZE.getKey());
            lambdaUpdateWrapper.set(SysUser::getFreezeDeadlineTime, (Object)DateUtil.offset((Date)new Date(), (DateField)DateField.DAY_OF_MONTH, (int)1));
            this.update((Wrapper)lambdaUpdateWrapper);
        }
        finally {
            TenantIdHolder.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempLoginUserInfo createTempUserInfo(Long userId) {
        if (ObjectUtil.isEmpty((Object)userId)) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUser::getUserId, (Object)userId);
        wrapper.select(new SFunction[]{SysUser::getUserId, SysUser::getAccount, SysUser::getTenantId, SysUser::getLastLoginIp, SysUser::getLastLoginTime});
        SysUser sysUser = null;
        try {
            TenantSwitchHolder.set((Boolean)false);
            sysUser = (SysUser)((Object)this.getOne((Wrapper)wrapper));
        }
        finally {
            TenantSwitchHolder.remove();
        }
        if (sysUser == null) {
            return null;
        }
        TempLoginUserInfo tempLoginUserInfo = new TempLoginUserInfo();
        tempLoginUserInfo.setUserId(sysUser.getUserId());
        tempLoginUserInfo.setAccount(sysUser.getAccount());
        tempLoginUserInfo.setTenantId(sysUser.getTenantId());
        tempLoginUserInfo.setLoginTime(sysUser.getLastLoginTime());
        tempLoginUserInfo.setLoginIp(sysUser.getLastLoginIp());
        return tempLoginUserInfo;
    }

    public List<SimpleDict> batchGetNameByUserIdList(Set<Long> userIdList) {
        SysUserRequest sysUserRequest = new SysUserRequest();
        sysUserRequest.setUserIdList(userIdList);
        return this.batchGetName(sysUserRequest);
    }

    public Set<Long> getUserComprehensiveIdentitySummary() {
        LoginUser loginUser = LoginContext.me().getLoginUserNullable();
        if (loginUser == null) {
            return new HashSet<Long>();
        }
        Long userId = loginUser.getUserId();
        Long currentOrgId = loginUser.getCurrentOrgId();
        List userRoleIdList = this.sysUserRoleService.getUserRoleIdList(userId);
        HashSet<Long> comprehensiveIdentity = new HashSet<Long>();
        if (ObjectUtil.isNotEmpty((Object)userId)) {
            comprehensiveIdentity.add(userId);
        }
        if (ObjectUtil.isNotEmpty((Object)currentOrgId)) {
            comprehensiveIdentity.add(currentOrgId);
        }
        if (ObjectUtil.isNotEmpty((Object)userRoleIdList)) {
            comprehensiveIdentity.addAll(userRoleIdList);
        }
        return comprehensiveIdentity;
    }

    public List<SimpleUserDTO> batchGetUserSimpleInfoList(Set<Long> userIdList) {
        if (ObjectUtil.isEmpty(userIdList)) {
            return new ArrayList<SimpleUserDTO>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysUser::getUserId, userIdList);
        wrapper.select(new SFunction[]{SysUser::getRealName, SysUser::getAccount, SysUser::getAvatar, SysUser::getUserId});
        List list2 = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)list2)) {
            return new ArrayList<SimpleUserDTO>();
        }
        List sortUsers = SortUtils.sortListByObjectKey((List)list2, new LinkedList<Long>(userIdList));
        ArrayList<SimpleUserDTO> simpleUserDTOS = new ArrayList<SimpleUserDTO>();
        for (SysUser sysUser : sortUsers) {
            SimpleUserDTO simpleUserDTO = new SimpleUserDTO();
            simpleUserDTO.setAccount(sysUser.getAccount());
            simpleUserDTO.setRealName(sysUser.getRealName());
            simpleUserDTO.setUserId(sysUser.getUserId());
            Long avatar = sysUser.getAvatar();
            String fileAuthUrl = null;
            try {
                fileAuthUrl = this.fileInfoApi.getFileAuthUrl(avatar);
            }
            catch (Exception e) {
                continue;
            }
            simpleUserDTO.setAvatarUrl(fileAuthUrl);
            simpleUserDTOS.add(simpleUserDTO);
        }
        return simpleUserDTOS;
    }

    public Long simpleAddUser(AddUserDTO addUserDTO, Long orgId, Long positionId) {
        SysUser simpleUser = SysUserCreateFactory.createSimpleAddUser(addUserDTO);
        this.save((Object)simpleUser);
        this.securityConfigService.recordPasswordEditLog(simpleUser.getUserId(), simpleUser.getPassword(), simpleUser.getPasswordSalt());
        this.sysUserOrgService.updateUserOrg(simpleUser.getUserId(), ListUtil.of((Object[])new SysUserOrg[]{SysUserCreateFactory.createOneUserOrg(simpleUser.getUserId(), orgId, positionId)}));
        this.sysUserRoleService.bindUserDefaultRole(simpleUser.getUserId());
        BusinessLogUtil.setLogTitle((String)("\u65b0\u589e\u7528\u6237\uff0c\u7528\u6237\u8d26\u53f7\uff1a" + simpleUser.getAccount()), (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u65b0\u589e\u7528\u6237\u8d26\u53f7\u4fe1\u606f\uff1a", simpleUser.getAccount()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a\n", simpleUser});
        return simpleUser.getUserId();
    }

    public UserInfoDetailDTO getUserDetailByEmail(String email) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysUser::getEmail, (Object)email);
        lambdaQueryWrapper.select(new SFunction[]{SysUser::getUserId, SysUser::getRealName, SysUser::getNickName, SysUser::getAccount, SysUser::getBirthday, SysUser::getSex, SysUser::getEmail, SysUser::getPhone, SysUser::getTel, SysUser::getSuperAdminFlag, SysUser::getStatusFlag, SysUser::getUserSort, SysUser::getMasterUserId});
        List list2 = this.list((Wrapper)lambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)list2)) {
            return null;
        }
        if (list2.size() > 1) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.EMAIL_REPEAT);
        }
        SysUser sysUser = (SysUser)((Object)list2.get(0));
        UserInfoDetailDTO userInfoDetailDTO = new UserInfoDetailDTO();
        BeanUtil.copyProperties((Object)((Object)sysUser), (Object)userInfoDetailDTO, (String[])new String[0]);
        return userInfoDetailDTO;
    }

    private SysUser querySysUser(SysUserRequest sysUserRequest) {
        SysUser sysUser = (SysUser)((Object)this.getById(sysUserRequest.getUserId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysUser))) {
            throw new ServiceException((AbstractExceptionEnum)SysUserExceptionEnum.SYS_USER_NOT_EXISTED);
        }
        return sysUser;
    }

    private LambdaQueryWrapper<SysUser> createWrapper(SysUserRequest sysUserRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = sysUserRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.nested(wrap -> {
                wrap.like(SysUser::getRealName, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(SysUser::getAccount, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(SysUser::getPhone, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(SysUser::getTel, (Object)searchText);
                ((LambdaQueryWrapper)wrap.or()).like(SysUser::getEmployeeNumber, (Object)searchText);
            });
        }
        Integer statusFlag = sysUserRequest.getStatusFlag();
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)statusFlag), SysUser::getStatusFlag, (Object)statusFlag);
        if (ObjectUtil.isNotEmpty((Object)sysUserRequest.getOrgIdCondition())) {
            List orgUserIdList = this.sysUserOrgService.getOrgUserIdList(sysUserRequest.getOrgIdCondition(), true);
            if (ObjectUtil.isEmpty((Object)orgUserIdList)) {
                queryWrapper.in(SysUser::getUserId, new Object[]{-1L});
            } else {
                queryWrapper.in(SysUser::getUserId, (Collection)orgUserIdList);
            }
        }
        UserDataScopeFactory.getUserDataScopeCondition((LambdaQueryWrapper<SysUser>)queryWrapper);
        queryWrapper.orderByAsc(SysUser::getUserSort);
        return queryWrapper;
    }

    private void baseRemoveUser(Set<Long> userIdList) {
        Map removeUserCallbackApiMap = SpringUtil.getBeansOfType(RemoveUserCallbackApi.class);
        for (RemoveUserCallbackApi removeUserCallbackApi : removeUserCallbackApiMap.values()) {
            removeUserCallbackApi.validateHaveUserBind(userIdList);
        }
        this.removeBatchByIds(userIdList);
        for (RemoveUserCallbackApi removeUserCallbackApi : removeUserCallbackApiMap.values()) {
            removeUserCallbackApi.removeUserAction(userIdList);
        }
    }

    private void updateSysUserFreezeStatus(String account, SysUser sysUserServiceOne) {
        Date freezeDeadlineTime;
        if (UserStatusEnum.TEMP_FREEZE.getCode().equals(sysUserServiceOne.getStatusFlag()) && (freezeDeadlineTime = sysUserServiceOne.getFreezeDeadlineTime()) != null && freezeDeadlineTime.before(new Date())) {
            sysUserServiceOne.setStatusFlag(UserStatusEnum.ENABLE.getCode());
            LambdaUpdateWrapper objectLambdaUpdateWrapper = new LambdaUpdateWrapper();
            objectLambdaUpdateWrapper.set(SysUser::getStatusFlag, (Object)UserStatusEnum.ENABLE.getCode());
            objectLambdaUpdateWrapper.set(SysUser::getFreezeDeadlineTime, null);
            objectLambdaUpdateWrapper.eq(SysUser::getAccount, (Object)account);
            this.update((Wrapper)objectLambdaUpdateWrapper);
        }
    }
}

