/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.login.service;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.sys.api.SysUserRoleServiceApi;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class UserPermissionService {
    @Resource
    private SysUserRoleServiceApi sysUserRoleServiceApi;
    @Resource
    private SysRoleMenuService sysRoleMenuService;
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysMenuOptionsService sysMenuOptionsService;

    public List<String> getUserPermissionCodeList(LoginUser loginUser) {
        Long userId = loginUser.getUserId();
        List roleIdList = this.sysUserRoleServiceApi.getUserRoleIdList(userId);
        if (ObjectUtil.isEmpty((Object)roleIdList)) {
            return new ArrayList<String>();
        }
        List<Long> menuIdList = this.sysRoleMenuService.getRoleBindMenuIdList(roleIdList);
        List<Long> menuOptionsIdList = this.sysRoleMenuOptionsService.getRoleBindMenuOptionsIdList(roleIdList);
        ArrayList<String> permissionCodeList = new ArrayList<String>();
        List<String> userMenuCodeList = this.sysMenuService.getMenuCodeList(menuIdList);
        permissionCodeList.addAll(userMenuCodeList);
        List<String> optionsCodeList = this.sysMenuOptionsService.getOptionsCodeList(menuOptionsIdList);
        permissionCodeList.addAll(optionsCodeList);
        return permissionCodeList;
    }
}

