/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.menu.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.enums.menu.MenuTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.enums.SysMenuExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.menu.pojo.request.SysMenuRequest;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

public class MenuValidateFactory {
    public static void validateAddMenuParam(SysMenuRequest sysMenuRequest) {
        long alreadyCount;
        SysMenuService sysMenuService = (SysMenuService)SpringUtil.getBean(SysMenuService.class);
        Long menuId = sysMenuRequest.getMenuId();
        String menuCode = sysMenuRequest.getMenuCode();
        LambdaQueryWrapper sysMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysMenuLambdaQueryWrapper.eq(SysMenu::getMenuCode, (Object)menuCode);
        if (menuId != null) {
            sysMenuLambdaQueryWrapper.ne(SysMenu::getMenuId, (Object)menuId);
        }
        if ((alreadyCount = sysMenuService.count((Wrapper)sysMenuLambdaQueryWrapper)) > 0L) {
            throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.MENU_CODE_REPEAT);
        }
        Integer menuType = sysMenuRequest.getMenuType();
        if (MenuTypeEnum.BACKEND_MENU.getKey().equals(menuType)) {
            if (ObjectUtil.isEmpty((Object)sysMenuRequest.getAntdvRouter())) {
                throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.URL_CANT_EMPTY);
            }
            if (ObjectUtil.isEmpty((Object)sysMenuRequest.getAntdvVisible())) {
                throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.HIDDEN_FLAG_CANT_EMPTY);
            }
        } else if (MenuTypeEnum.FRONT_VUE.getKey().equals(menuType)) {
            if (ObjectUtil.isEmpty((Object)sysMenuRequest.getAntdvRouter())) {
                throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.URL_CANT_EMPTY);
            }
            if (ObjectUtil.isEmpty((Object)sysMenuRequest.getAntdvComponent())) {
                throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.COMPONENT_PATH_CANT_EMPTY);
            }
        } else if (MenuTypeEnum.INNER_URL.getKey().equals(menuType)) {
            if (ObjectUtil.isEmpty((Object)sysMenuRequest.getAntdvRouter())) {
                throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.URL_CANT_EMPTY);
            }
            if (ObjectUtil.isEmpty((Object)sysMenuRequest.getAntdvComponent())) {
                throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.COMPONENT_PATH_CANT_EMPTY);
            }
        } else if (MenuTypeEnum.OUT_URL.getKey().equals(menuType) && ObjectUtil.isEmpty((Object)sysMenuRequest.getAntdvRouter())) {
            throw new ServiceException((AbstractExceptionEnum)SysMenuExceptionEnum.URL_CANT_EMPTY);
        }
    }
}

