/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.resource.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.scanner.api.ResourceReportApi;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ReportResourceParam;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.SysResourcePersistencePojo;
import cn.stylefeng.roses.kernel.sys.modular.resource.entity.SysResource;
import cn.stylefeng.roses.kernel.sys.modular.resource.factory.ResourceFactory;
import cn.stylefeng.roses.kernel.sys.modular.resource.service.SysResourceService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class DefaultResourceReporter
implements ResourceReportApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceReporter.class);
    @Resource
    private SysResourceService sysResourceService;
    @Resource(name="resourceCache")
    private CacheOperatorApi<ResourceDefinition> resourceCache;

    @Transactional(rollbackFor={Exception.class})
    public void reportResources(@RequestBody ReportResourceParam reportResourceReq) {
        this.reportResourcesAndGetResult(reportResourceReq);
    }

    public List<SysResourcePersistencePojo> reportResourcesAndGetResult(ReportResourceParam reportResourceReq) {
        String projectCode = reportResourceReq.getProjectCode();
        Map resourceDefinitions = reportResourceReq.getResourceDefinitions();
        if (ObjectUtil.isEmpty((Object)projectCode) || resourceDefinitions == null) {
            return new ArrayList<SysResourcePersistencePojo>();
        }
        ArrayList<SysResource> allResources = new ArrayList<SysResource>();
        ArrayList<ResourceDefinition> resourceDefinitionArrayList = new ArrayList<ResourceDefinition>();
        for (Map.Entry entry : resourceDefinitions.entrySet()) {
            Map map = (Map)entry.getValue();
            for (Map.Entry modularResources : map.entrySet()) {
                resourceDefinitionArrayList.add((ResourceDefinition)modularResources.getValue());
                SysResource resource = ResourceFactory.createResource((ResourceDefinition)modularResources.getValue());
                allResources.add(resource);
            }
        }
        CompletableFuture.runAsync(() -> {
            this.sysResourceService.deleteResourceByProjectCode(projectCode);
            this.sysResourceService.batchSaveResourceList(allResources);
        }).exceptionally(ex -> {
            log.error("\u8d44\u6e90\u626b\u63cf\u4fdd\u5b58\u5230\u5e93\u4e2d\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u95ee\u9898\uff0c\u4ee5\u514d\u5f71\u54cd\u540e\u7eed\u8fd0\u884c\uff01", ex);
            return null;
        });
        Map<String, ResourceDefinition> resourceDefinitionMap = ResourceFactory.orderedResourceDefinition(resourceDefinitionArrayList);
        for (Map.Entry<String, ResourceDefinition> entry : resourceDefinitionMap.entrySet()) {
            this.resourceCache.put(entry.getKey(), (Object)entry.getValue());
        }
        ArrayList<SysResourcePersistencePojo> arrayList = new ArrayList<SysResourcePersistencePojo>();
        for (SysResource item : allResources) {
            SysResourcePersistencePojo sysResourcePersistencePojo = new SysResourcePersistencePojo();
            BeanUtil.copyProperties((Object)((Object)item), (Object)sysResourcePersistencePojo, (String[])new String[0]);
            arrayList.add(sysResourcePersistencePojo);
        }
        return arrayList;
    }
}

