/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.controller;

import cn.stylefeng.roses.kernel.rule.annotation.BizLog;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRole;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindDataScopeRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindPermissionRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.SysRoleRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.response.RoleBindDataScopeResponse;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.response.RoleBindPermissionResponse;
import cn.stylefeng.roses.kernel.sys.modular.role.service.PermissionAssignService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleDataScopeService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleService;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u6743\u9650\u5206\u914d\u754c\u9762\u7684\u63a5\u53e3")
public class PermissionAssignController {
    @Resource
    private SysRoleService sysRoleService;
    @Resource
    private PermissionAssignService permissionAssignService;
    @Resource
    private SysRoleDataScopeService sysRoleDataScopeService;

    @GetResource(name="\u83b7\u53d6\u6240\u6709\u89d2\u8272\u5217\u8868", path={"/permission/getRoleList"})
    public ResponseData<List<SysRole>> getRoleList(SysRoleRequest sysRoleRequest) {
        return new SuccessResponseData(this.sysRoleService.permissionGetRoleList(sysRoleRequest));
    }

    @GetResource(name="\u83b7\u53d6\u89d2\u8272\u7ed1\u5b9a\u7684\u6743\u9650\u5217\u8868", path={"/permission/getRoleBindPermission"}, requiredPermission=true, requirePermissionCode="CHANGE_ROLE_PERMISSION")
    public ResponseData<RoleBindPermissionResponse> getRoleBindPermission(@Validated(value={BaseRequest.detail.class}) RoleBindPermissionRequest roleBindPermissionRequest) {
        RoleBindPermissionResponse roleBindPermission2 = this.permissionAssignService.getRoleBindPermission(roleBindPermissionRequest);
        return new SuccessResponseData((Object)roleBindPermission2);
    }

    @PostResource(name="\u66f4\u65b0\u89d2\u8272\u7ed1\u5b9a\u6743\u9650", path={"/permission/updateRoleBindPermission"}, requiredPermission=true, requirePermissionCode="CHANGE_ROLE_PERMISSION")
    @BizLog(logTypeCode="CHANGE_ROLE_PERMISSION")
    public ResponseData<?> updateRoleBindPermission(@RequestBody @Validated(value={RoleBindPermissionRequest.roleBindPermission.class}) RoleBindPermissionRequest roleBindPermissionRequest) {
        this.permissionAssignService.updateRoleBindPermission(roleBindPermissionRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u83b7\u53d6\u89d2\u8272\u7684\u6570\u636e\u6743\u9650\u8be6\u60c5", path={"/permission/getRoleBindDataScope"}, requiredPermission=true, requirePermissionCode="CHANGE_ROLE_DATA_SCOPE")
    public ResponseData<RoleBindDataScopeResponse> getRoleBindDataScope(@Validated(value={BaseRequest.detail.class}) RoleBindDataScopeRequest roleBindDataScopeRequest) {
        RoleBindDataScopeResponse roleBindDataScopeResponse = this.sysRoleDataScopeService.getRoleBindDataScope(roleBindDataScopeRequest);
        return new SuccessResponseData((Object)roleBindDataScopeResponse);
    }

    @PostResource(name="\u89d2\u8272\u7ed1\u5b9a\u6570\u636e\u6743\u9650\u7684\u914d\u7f6e", path={"/permission/updateRoleBindDataScope"}, requiredPermission=true, requirePermissionCode="CHANGE_ROLE_DATA_SCOPE")
    @BizLog(logTypeCode="CHANGE_ROLE_DATA_SCOPE")
    public ResponseData<?> updateRoleBindDataScope(@RequestBody @Validated(value={RoleBindDataScopeRequest.roleBindDataScope.class}) RoleBindDataScopeRequest roleBindDataScopeRequest) {
        this.sysRoleDataScopeService.updateRoleBindDataScope(roleBindDataScopeRequest);
        return new SuccessResponseData();
    }
}

