/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.event.sdk.publish.BusinessEventPublisher;
import cn.stylefeng.roses.kernel.log.api.util.BusinessLogUtil;
import cn.stylefeng.roses.kernel.sys.api.SysUserRoleServiceApi;
import cn.stylefeng.roses.kernel.sys.modular.app.entity.SysApp;
import cn.stylefeng.roses.kernel.sys.modular.app.service.SysAppService;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleAssignOperateAction;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenu;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.role.factory.PermissionAssignFactory;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindPermissionRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.response.RoleBindPermissionItem;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.response.RoleBindPermissionResponse;
import cn.stylefeng.roses.kernel.sys.modular.role.service.PermissionAssignService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleDataScopeService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import jakarta.annotation.Resource;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PermissionAssignServiceImpl
implements PermissionAssignService {
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysAppService sysAppService;
    @Resource
    private SysMenuOptionsService sysMenuOptionsService;
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource
    private SysRoleMenuService sysRoleMenuService;
    @Resource
    private SysUserRoleServiceApi sysUserRoleServiceApi;
    @Resource
    private SysRoleService sysRoleService;
    @Resource
    private DbOperatorApi dbOperatorApi;
    @Resource
    private SysRoleDataScopeService sysRoleDataScopeService;
    @Resource
    private SysUserRoleServiceApi userRoleServiceApi;

    @Override
    public RoleBindPermissionResponse getRoleBindPermission(RoleBindPermissionRequest roleBindPermissionRequest) {
        Set userRoleLimitScope = this.userRoleServiceApi.findCurrentUserRoleLimitScope();
        RoleBindPermissionResponse selectTreeStructure = this.createSelectTreeStructure(userRoleLimitScope);
        Set<Long> roleBindMenusAndOptions = this.getRoleBindMenusAndOptions(roleBindPermissionRequest.getRoleId());
        return PermissionAssignFactory.fillCheckedFlag(selectTreeStructure, roleBindMenusAndOptions);
    }

    @Override
    public void updateRoleBindPermission(RoleBindPermissionRequest roleBindPermissionRequest) {
        BusinessLogUtil.setLogTitle((String)"\u66f4\u65b0\u89d2\u8272\u7ed1\u5b9a\u7684\u6743\u9650", (String[])new String[0]);
        Set userRoleLimitScope = this.userRoleServiceApi.findCurrentUserRoleLimitScope();
        Map operateActionMap = SpringUtil.getBeansOfType(RoleAssignOperateAction.class);
        for (RoleAssignOperateAction roleAssignOperateAction : operateActionMap.values()) {
            if (!roleAssignOperateAction.getNodeType().getCode().equals(roleBindPermissionRequest.getPermissionNodeType())) continue;
            roleAssignOperateAction.doOperateAction(roleBindPermissionRequest, userRoleLimitScope);
            BusinessEventPublisher.publishEvent((String)"ROLE_BIND_MENU_EVENT", (Object)roleBindPermissionRequest.getRoleId());
            BusinessEventPublisher.publishEvent((String)"ROLE_BIND_MENU_OPTIONS_EVENT", (Object)roleBindPermissionRequest.getRoleId());
            BusinessLogUtil.addContent((Object[])new Object[]{"\u89d2\u8272\u7ed1\u5b9a\u6743\u9650\u7684\u76f8\u5173\u53c2\u6570\u5982\u4e0b\uff1a\n", roleBindPermissionRequest});
            return;
        }
    }

    @Override
    public RoleBindPermissionResponse createSelectTreeStructure() {
        return this.createSelectTreeStructure(null);
    }

    @Override
    public RoleBindPermissionResponse createSelectTreeStructure(Set<Long> limitMenuIdsAndOptionIds) {
        List<SysMenu> totalMenus = null;
        totalMenus = ObjectUtil.isEmpty(limitMenuIdsAndOptionIds) ? this.sysMenuService.getTotalMenus() : this.sysMenuService.getTotalMenus(limitMenuIdsAndOptionIds);
        List<RoleBindPermissionItem> totalResultMenus = PermissionAssignFactory.createPermissionMenus(totalMenus);
        Set appIdList = totalMenus.stream().map(SysMenu::getAppId).collect(Collectors.toSet());
        LambdaQueryWrapper sysAppLambdaQueryWrapper = new LambdaQueryWrapper();
        sysAppLambdaQueryWrapper.in(SysApp::getAppId, appIdList);
        sysAppLambdaQueryWrapper.select(new SFunction[]{SysApp::getAppId, SysApp::getAppName});
        sysAppLambdaQueryWrapper.orderByAsc(SysApp::getAppSort);
        List totalAppList = this.sysAppService.list((Wrapper)sysAppLambdaQueryWrapper);
        List<RoleBindPermissionItem> totalResultApps = PermissionAssignFactory.createApps(totalAppList);
        LambdaQueryWrapper optionsLambdaQueryWrapper = new LambdaQueryWrapper();
        optionsLambdaQueryWrapper.select(new SFunction[]{SysMenuOptions::getMenuId, SysMenuOptions::getMenuOptionId, SysMenuOptions::getOptionName});
        Set menuIds = totalResultMenus.stream().map(i -> Long.valueOf(i.getNodeId())).collect(Collectors.toSet());
        optionsLambdaQueryWrapper.in(SysMenuOptions::getMenuId, menuIds);
        if (ObjectUtil.isNotEmpty(limitMenuIdsAndOptionIds)) {
            optionsLambdaQueryWrapper.in(SysMenuOptions::getMenuOptionId, limitMenuIdsAndOptionIds);
        }
        List sysMenuOptionsList = this.sysMenuOptionsService.list((Wrapper)optionsLambdaQueryWrapper);
        List<RoleBindPermissionItem> totalResultOptions = PermissionAssignFactory.createMenuOptions(sysMenuOptionsList);
        return PermissionAssignFactory.composeSelectStructure(totalResultApps, totalResultMenus, totalResultOptions);
    }

    @Override
    public Set<Long> getRoleBindMenusAndOptions(Long roleId) {
        HashSet<Long> resultPermissions = new HashSet<Long>();
        LambdaQueryWrapper sysRoleMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuLambdaQueryWrapper.select(new SFunction[]{SysRoleMenu::getMenuId});
        sysRoleMenuLambdaQueryWrapper.eq(SysRoleMenu::getRoleId, (Object)roleId);
        List sysRoleMenuList = this.sysRoleMenuService.list((Wrapper)sysRoleMenuLambdaQueryWrapper);
        Set menuIdSet = sysRoleMenuList.stream().map(SysRoleMenu::getMenuId).collect(Collectors.toSet());
        resultPermissions.addAll(menuIdSet);
        LambdaQueryWrapper sysRoleMenuOptionsLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuOptionsLambdaQueryWrapper.select(new SFunction[]{SysRoleMenuOptions::getMenuOptionId});
        sysRoleMenuOptionsLambdaQueryWrapper.eq(SysRoleMenuOptions::getRoleId, (Object)roleId);
        List sysRoleMenuOptionsList = this.sysRoleMenuOptionsService.list((Wrapper)sysRoleMenuOptionsLambdaQueryWrapper);
        Set optionsIds = sysRoleMenuOptionsList.stream().map(SysRoleMenuOptions::getMenuOptionId).collect(Collectors.toSet());
        resultPermissions.addAll(optionsIds);
        return resultPermissions;
    }
}

