/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleAssignOperateAction;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleBindLimitAction;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleLimit;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenu;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.PermissionNodeTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.RoleLimitTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindPermissionRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleLimitService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.util.AssertAssignUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RoleBindAppImpl
implements RoleAssignOperateAction,
RoleBindLimitAction {
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysMenuOptionsService sysMenuOptionsService;
    @Resource
    private SysRoleMenuService sysRoleMenuService;
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource
    private SysRoleLimitService sysRoleLimitService;

    @Override
    public PermissionNodeTypeEnum getNodeType() {
        return PermissionNodeTypeEnum.APP;
    }

    @Override
    public void doOperateAction(RoleBindPermissionRequest roleBindPermissionRequest, Set<Long> roleLimitMenuIdsAndOptionIds) {
        Long roleId = roleBindPermissionRequest.getRoleId();
        Long appId = roleBindPermissionRequest.getNodeId();
        Set<Long> appMenuIds = this.getAppMenuIds(appId, roleLimitMenuIdsAndOptionIds);
        if (ObjectUtil.isEmpty(appMenuIds)) {
            return;
        }
        List<SysMenuOptions> totalMenuOptions = this.getAppMenuOptions(appId, roleLimitMenuIdsAndOptionIds);
        Set totalMenuOptionIds = totalMenuOptions.stream().map(SysMenuOptions::getMenuOptionId).collect(Collectors.toSet());
        LambdaQueryWrapper sysRoleMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuLambdaQueryWrapper.eq(SysRoleMenu::getRoleId, (Object)roleId);
        sysRoleMenuLambdaQueryWrapper.in(SysRoleMenu::getMenuId, appMenuIds);
        this.sysRoleMenuService.remove((Wrapper)sysRoleMenuLambdaQueryWrapper);
        if (ObjectUtil.isNotEmpty(totalMenuOptionIds)) {
            LambdaQueryWrapper sysRoleMenuOptionsLambdaQueryWrapper = new LambdaQueryWrapper();
            sysRoleMenuOptionsLambdaQueryWrapper.eq(SysRoleMenuOptions::getRoleId, (Object)roleId);
            sysRoleMenuOptionsLambdaQueryWrapper.in(SysRoleMenuOptions::getMenuOptionId, totalMenuOptionIds);
            AssertAssignUtil.assertAssign(roleId, (LambdaQueryWrapper<SysRoleMenuOptions>)sysRoleMenuOptionsLambdaQueryWrapper);
            this.sysRoleMenuOptionsService.remove((Wrapper)sysRoleMenuOptionsLambdaQueryWrapper);
        }
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            ArrayList<SysRoleMenu> sysRoleMenuList = new ArrayList<SysRoleMenu>();
            for (Long menuId : appMenuIds) {
                SysRoleMenu sysRoleMenu = new SysRoleMenu();
                sysRoleMenu.setRoleId(roleId);
                sysRoleMenu.setAppId(appId);
                sysRoleMenu.setMenuId(menuId);
                sysRoleMenuList.add(sysRoleMenu);
            }
            this.sysRoleMenuService.saveBatch(sysRoleMenuList);
            ArrayList<SysRoleMenuOptions> sysRoleMenuOptionsList = new ArrayList<SysRoleMenuOptions>();
            for (SysMenuOptions menuOptionItem : totalMenuOptions) {
                SysRoleMenuOptions sysRoleMenuOptions = new SysRoleMenuOptions();
                sysRoleMenuOptions.setRoleId(roleId);
                sysRoleMenuOptions.setAppId(appId);
                sysRoleMenuOptions.setMenuId(menuOptionItem.getMenuId());
                sysRoleMenuOptions.setMenuOptionId(menuOptionItem.getMenuOptionId());
                sysRoleMenuOptionsList.add(sysRoleMenuOptions);
            }
            this.sysRoleMenuOptionsService.saveBatch(sysRoleMenuOptionsList);
        }
    }

    @Override
    public PermissionNodeTypeEnum getRoleBindLimitNodeType() {
        return this.getNodeType();
    }

    @Override
    public void doRoleBindLimitAction(RoleBindPermissionRequest roleBindPermissionRequest) {
        Long roleId = roleBindPermissionRequest.getRoleId();
        Long appId = roleBindPermissionRequest.getNodeId();
        Set<Long> menuIds = this.getAppMenuIds(appId);
        if (ObjectUtil.isEmpty(menuIds)) {
            return;
        }
        List<SysMenuOptions> totalMenuOptions = this.getAppMenuOptions(appId);
        Set menuOptionIds = totalMenuOptions.stream().map(SysMenuOptions::getMenuOptionId).collect(Collectors.toSet());
        List totalBusinessId = ListUtil.list((boolean)false, menuIds);
        if (ObjectUtil.isNotEmpty(menuOptionIds)) {
            totalBusinessId.addAll(menuOptionIds);
        }
        LambdaQueryWrapper sysRoleLimitLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLimitLambdaQueryWrapper.eq(SysRoleLimit::getRoleId, (Object)roleId);
        sysRoleLimitLambdaQueryWrapper.in(SysRoleLimit::getBusinessId, (Collection)totalBusinessId);
        this.sysRoleLimitService.remove((Wrapper)sysRoleLimitLambdaQueryWrapper);
        if (roleBindPermissionRequest.getChecked().booleanValue()) {
            SysRoleLimit sysRoleLimit;
            ArrayList<SysRoleLimit> totalRoleLimit = new ArrayList<SysRoleLimit>();
            for (Long menuId : menuIds) {
                sysRoleLimit = new SysRoleLimit();
                sysRoleLimit.setRoleId(roleId);
                sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU.getCode());
                sysRoleLimit.setBusinessId(menuId);
                totalRoleLimit.add(sysRoleLimit);
            }
            if (ObjectUtil.isNotEmpty(menuOptionIds)) {
                for (Long optionsId : menuOptionIds) {
                    sysRoleLimit = new SysRoleLimit();
                    sysRoleLimit.setRoleId(roleId);
                    sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU_OPTIONS.getCode());
                    sysRoleLimit.setBusinessId(optionsId);
                    totalRoleLimit.add(sysRoleLimit);
                }
            }
            this.sysRoleLimitService.saveBatch(totalRoleLimit);
        }
    }

    private Set<Long> getAppMenuIds(Long appId) {
        return this.getAppMenuIds(appId, null);
    }

    private Set<Long> getAppMenuIds(Long appId, Set<Long> roleLimitMenuIdsAndOptionIds) {
        LambdaQueryWrapper menuLambdaQueryWrapper = new LambdaQueryWrapper();
        menuLambdaQueryWrapper.eq(SysMenu::getAppId, (Object)appId);
        if (ObjectUtil.isNotEmpty(roleLimitMenuIdsAndOptionIds)) {
            menuLambdaQueryWrapper.in(SysMenu::getMenuId, roleLimitMenuIdsAndOptionIds);
        }
        menuLambdaQueryWrapper.select(new SFunction[]{SysMenu::getMenuId});
        List totalMenus = this.sysMenuService.list((Wrapper)menuLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)totalMenus)) {
            return new HashSet<Long>();
        }
        return totalMenus.stream().map(SysMenu::getMenuId).collect(Collectors.toSet());
    }

    private List<SysMenuOptions> getAppMenuOptions(Long appId) {
        return this.getAppMenuOptions(appId, null);
    }

    private List<SysMenuOptions> getAppMenuOptions(Long appId, Set<Long> roleLimitMenuIdsAndOptionIds) {
        LambdaQueryWrapper menuOptionsLambdaQueryWrapper = new LambdaQueryWrapper();
        menuOptionsLambdaQueryWrapper.eq(SysMenuOptions::getAppId, (Object)appId);
        if (ObjectUtil.isNotEmpty(roleLimitMenuIdsAndOptionIds)) {
            menuOptionsLambdaQueryWrapper.in(SysMenuOptions::getMenuOptionId, roleLimitMenuIdsAndOptionIds);
        }
        menuOptionsLambdaQueryWrapper.select(new SFunction[]{SysMenuOptions::getMenuOptionId, SysMenuOptions::getMenuId});
        return this.sysMenuOptionsService.list((Wrapper)menuOptionsLambdaQueryWrapper);
    }
}

