/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.sys.modular.role.action.RoleBindLimitAction;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleLimit;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.RoleLimitTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.factory.PermissionAssignFactory;
import cn.stylefeng.roses.kernel.sys.modular.role.mapper.SysRoleLimitMapper;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.RoleBindPermissionRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.response.RoleBindPermissionResponse;
import cn.stylefeng.roses.kernel.sys.modular.role.service.PermissionAssignService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleLimitService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleLimitServiceImpl
extends ServiceImpl<SysRoleLimitMapper, SysRoleLimit>
implements SysRoleLimitService {
    @Resource
    private PermissionAssignService permissionAssignService;

    @Override
    public RoleBindPermissionResponse getRoleLimit(RoleBindPermissionRequest roleBindPermissionRequest) {
        RoleBindPermissionResponse selectTreeStructure = this.permissionAssignService.createSelectTreeStructure();
        Set<Long> roleBindLimitList = this.getRoleBindLimitList(roleBindPermissionRequest.getRoleId());
        return PermissionAssignFactory.fillCheckedFlag(selectTreeStructure, roleBindLimitList);
    }

    @Override
    public void updateRoleBindLimit(RoleBindPermissionRequest roleBindPermissionRequest) {
        Map operateActionMap = SpringUtil.getBeansOfType(RoleBindLimitAction.class);
        for (RoleBindLimitAction roleBindLimitAction : operateActionMap.values()) {
            if (!roleBindLimitAction.getRoleBindLimitNodeType().getCode().equals(roleBindPermissionRequest.getPermissionNodeType())) continue;
            roleBindLimitAction.doRoleBindLimitAction(roleBindPermissionRequest);
            return;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRoleLimit(Long roleId, Set<Long> menuIdList, Set<Long> menuOptionIdList) {
        SysRoleLimit sysRoleLimit;
        LambdaQueryWrapper sysRoleLimitLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLimitLambdaQueryWrapper.eq(SysRoleLimit::getRoleId, (Object)roleId);
        this.remove((Wrapper)sysRoleLimitLambdaQueryWrapper);
        ArrayList<SysRoleLimit> sysRoleLimits = new ArrayList<SysRoleLimit>();
        if (ObjectUtil.isNotEmpty(menuIdList)) {
            for (Long menuId : menuIdList) {
                sysRoleLimit = new SysRoleLimit();
                sysRoleLimit.setRoleId(roleId);
                sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU.getCode());
                sysRoleLimit.setBusinessId(menuId);
                sysRoleLimits.add(sysRoleLimit);
            }
        }
        if (ObjectUtil.isNotEmpty(menuOptionIdList)) {
            for (Long menuOptionId : menuOptionIdList) {
                sysRoleLimit = new SysRoleLimit();
                sysRoleLimit.setRoleId(roleId);
                sysRoleLimit.setLimitType(RoleLimitTypeEnum.MENU_OPTIONS.getCode());
                sysRoleLimit.setBusinessId(menuOptionId);
                sysRoleLimits.add(sysRoleLimit);
            }
        }
        if (ObjectUtil.isNotEmpty(sysRoleLimits)) {
            this.saveBatch(sysRoleLimits);
        }
    }

    public Set<Long> getRoleBindLimitList(Long roleId) {
        return this.getRoleBindLimitList(ListUtil.toList((Object[])new Long[]{roleId}));
    }

    public Set<Long> getRoleBindLimitList(List<Long> roleIdList) {
        if (ObjectUtil.isEmpty(roleIdList)) {
            return new HashSet<Long>();
        }
        LambdaQueryWrapper sysRoleLimitLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLimitLambdaQueryWrapper.select(new SFunction[]{SysRoleLimit::getBusinessId});
        sysRoleLimitLambdaQueryWrapper.in(SysRoleLimit::getRoleId, roleIdList);
        List sysRoleMenuList = this.list((Wrapper)sysRoleLimitLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)sysRoleMenuList)) {
            return new HashSet<Long>();
        }
        return sysRoleMenuList.stream().map(SysRoleLimit::getBusinessId).collect(Collectors.toSet());
    }
}

