/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveMenuCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveRoleCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.constants.SysConstants;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRoleMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.role.mapper.SysRoleMenuOptionsMapper;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleMenuOptionsServiceImpl
extends ServiceImpl<SysRoleMenuOptionsMapper, SysRoleMenuOptions>
implements SysRoleMenuOptionsService,
RemoveRoleCallbackApi,
RemoveMenuCallbackApi {
    @Resource(name="roleMenuOptionsCache")
    private CacheOperatorApi<List<Long>> roleMenuOptionsCache;

    @Override
    public void removeRoleBindOptions(Long optionsId) {
        LambdaQueryWrapper sysRoleMenuOptionsLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuOptionsLambdaQueryWrapper.eq(SysRoleMenuOptions::getMenuOptionId, (Object)optionsId);
        this.remove((Wrapper)sysRoleMenuOptionsLambdaQueryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindRoleMenuOptions(Long roleId, List<SysMenuOptions> sysMenuOptionsList) {
        if (ObjectUtil.isEmpty((Object)roleId) || ObjectUtil.isEmpty(sysMenuOptionsList)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleMenuOptions::getRoleId, (Object)roleId);
        this.remove((Wrapper)queryWrapper);
        ArrayList<SysRoleMenuOptions> sysRoleMenuOptionList = new ArrayList<SysRoleMenuOptions>();
        for (SysMenuOptions sysMenuOptions : sysMenuOptionsList) {
            SysRoleMenuOptions roleMenuOptionItem = new SysRoleMenuOptions();
            roleMenuOptionItem.setRoleId(roleId);
            roleMenuOptionItem.setMenuOptionId(sysMenuOptions.getMenuOptionId());
            roleMenuOptionItem.setMenuId(sysMenuOptions.getMenuId());
            roleMenuOptionItem.setAppId(sysMenuOptions.getAppId());
            sysRoleMenuOptionList.add(roleMenuOptionItem);
        }
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((SysRoleMenuOptionsMapper)this.getBaseMapper()).insertBatchSomeColumn(sysRoleMenuOptionList);
        } else {
            this.saveBatch(sysRoleMenuOptionList);
        }
        this.roleMenuOptionsCache.remove(new String[]{String.valueOf(roleId)});
    }

    @Override
    public List<Long> getRoleBindMenuOptionsIdList(List<Long> roleIdList) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (ObjectUtil.isEmpty(roleIdList)) {
            return result;
        }
        for (Long roleId : roleIdList) {
            String roleIdKey = roleId.toString();
            List optionsCached = (List)this.roleMenuOptionsCache.get(roleIdKey);
            if (ObjectUtil.isNotEmpty((Object)optionsCached)) {
                result.addAll(optionsCached);
                continue;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysRoleMenuOptions::getRoleId, (Object)roleId);
            queryWrapper.select(new SFunction[]{SysRoleMenuOptions::getMenuOptionId});
            List roleMenuOptions = this.list((Wrapper)queryWrapper);
            if (!ObjectUtil.isNotEmpty((Object)roleMenuOptions)) continue;
            List menuOptionsIdQueryResult = roleMenuOptions.stream().map(SysRoleMenuOptions::getMenuOptionId).collect(Collectors.toList());
            result.addAll(menuOptionsIdQueryResult);
            this.roleMenuOptionsCache.put(roleIdKey, menuOptionsIdQueryResult, SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS);
        }
        return result;
    }

    public void validateHaveRoleBind(Set<Long> beRemovedRoleIdList) {
    }

    public void removeRoleAction(Set<Long> beRemovedRoleIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysRoleMenuOptions::getRoleId, beRemovedRoleIdList);
        this.remove((Wrapper)wrapper);
        this.roleMenuOptionsCache.remove((Collection)beRemovedRoleIdList.stream().map(Object::toString).collect(Collectors.toList()));
    }

    public void removeMenuAction(Set<Long> beRemovedMenuIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleMenuOptions::getMenuId, beRemovedMenuIdList);
        this.remove((Wrapper)queryWrapper);
    }
}

