/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.util.BusinessLogUtil;
import cn.stylefeng.roses.kernel.rule.enums.permission.DataScopeTypeEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveRoleCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.enums.role.RoleTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.role.SysRoleDTO;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenuOptions;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRole;
import cn.stylefeng.roses.kernel.sys.modular.role.enums.exception.SysRoleExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.role.mapper.SysRoleMapper;
import cn.stylefeng.roses.kernel.sys.modular.role.pojo.request.SysRoleRequest;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleLimitService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRole>
implements SysRoleService {
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource
    private SysMenuOptionsService sysMenuOptionsService;
    @Resource
    private SysRoleMenuService sysRoleMenuService;
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysRoleLimitService sysRoleLimitService;

    @Override
    public void add(SysRoleRequest sysRoleRequest) {
        this.rolePermissionValidate(sysRoleRequest);
        SysRole sysRole = new SysRole();
        BeanUtil.copyProperties((Object)((Object)sysRoleRequest), (Object)((Object)sysRole), (String[])new String[0]);
        sysRole.setDataScopeType(DataScopeTypeEnum.DEPT_WITH_CHILD.getCode());
        this.save((Object)sysRole);
        BusinessLogUtil.setLogTitle((String)"\u6dfb\u52a0\u89d2\u8272\uff0c\u89d2\u8272\u540d\u79f0\uff1a", (String[])new String[]{sysRoleRequest.getRoleName()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u89d2\u8272\u4fe1\u606f\u8be6\u60c5\u5982\u4e0b\uff1a\n", sysRole});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysRoleRequest sysRoleRequest) {
        Long currentUserCompanyId;
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        if (RoleTypeEnum.SYSTEM_ROLE.getCode().equals(sysRole.getRoleType())) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.SYSTEM_ROLE_CANT_DELETE);
        }
        if (!(LoginContext.me().getSuperAdminFlag() || (currentUserCompanyId = LoginContext.me().getCurrentUserCompanyId()) != null && currentUserCompanyId.equals(sysRole.getRoleCompanyId()))) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.DEL_PERMISSION_ERROR);
        }
        this.baseDelete(CollectionUtil.set((boolean)false, (Object[])new Long[]{sysRole.getRoleId()}));
        BusinessLogUtil.setLogTitle((String)"\u5220\u9664\u89d2\u8272\uff0c\u89d2\u8272\u540d\u79f0\uff1a", (String[])new String[]{sysRole.getRoleName()});
        BusinessLogUtil.addContent((Object[])new Object[]{"\u89d2\u8272\u4fe1\u606f\u8be6\u60c5\u5982\u4e0b\uff1a\n", sysRole});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRole::getRoleId, sysRoleRequest.getRoleIdList());
        queryWrapper.eq(SysRole::getRoleType, (Object)RoleTypeEnum.SYSTEM_ROLE.getCode());
        long haveSystemFlagCount = this.count((Wrapper)queryWrapper);
        if (haveSystemFlagCount > 0L) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.SYSTEM_ROLE_CANT_DELETE);
        }
        if (!LoginContext.me().getSuperAdminFlag()) {
            LambdaQueryWrapper tempWrapper = new LambdaQueryWrapper();
            tempWrapper.in(SysRole::getRoleId, sysRoleRequest.getRoleIdList());
            tempWrapper.ne(SysRole::getRoleCompanyId, (Object)LoginContext.me().getCurrentUserCompanyId());
            long notMeCreateCount = this.count((Wrapper)tempWrapper);
            if (notMeCreateCount > 0L) {
                throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.DEL_PERMISSION_ERROR);
            }
        }
        this.baseDelete(sysRoleRequest.getRoleIdList());
        BusinessLogUtil.setLogTitle((String)"\u6279\u91cf\u5220\u9664\u89d2\u8272", (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u89d2\u8272id\u96c6\u5408\u5982\u4e0b\uff1a\n", sysRoleRequest.getRoleIdList()});
    }

    @Override
    public void edit(SysRoleRequest sysRoleRequest) {
        this.rolePermissionValidate(sysRoleRequest);
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        BusinessLogUtil.setLogTitle((String)"\u4fee\u6539\u89d2\u8272\u4fe1\u606f", (String[])new String[0]);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u539f\u89d2\u8272\u4fe1\u606f\u5982\u4e0b\uff1a\n", sysRole});
        if (!sysRole.getRoleCode().equals(sysRoleRequest.getRoleCode())) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.SUPER_ADMIN_ROLE_CODE_ERROR);
        }
        BeanUtil.copyProperties((Object)((Object)sysRoleRequest), (Object)((Object)sysRole), (String[])new String[0]);
        if (RoleTypeEnum.SYSTEM_ROLE.getCode().equals(sysRoleRequest.getRoleType())) {
            sysRole.setRoleCompanyId(null);
        }
        this.updateById((Object)sysRole);
        BusinessLogUtil.addContent((Object[])new Object[]{"\u4fee\u6539\u540e\u89d2\u8272\u4fe1\u606f\u5982\u4e0b\uff1a\n", sysRole});
    }

    @Override
    public SysRole detail(SysRoleRequest sysRoleRequest) {
        return this.querySysRole(sysRoleRequest);
    }

    @Override
    public PageResult<SysRole> findPage(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper<SysRole> wrapper = this.createWrapper(sysRoleRequest);
        wrapper.select(new SFunction[]{SysRole::getRoleName, SysRole::getRoleCode, SysRole::getRoleSort, SysRole::getRoleId, BaseEntity::getCreateTime, SysRole::getRoleType, SysRole::getRoleCompanyId});
        this.filterRolePermission(wrapper, sysRoleRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public Integer getRoleDataScopeType(Long roleId) {
        Integer dataScopeType;
        if (ObjectUtil.isEmpty((Object)roleId)) {
            return DataScopeTypeEnum.SELF.getCode();
        }
        LambdaQueryWrapper sysRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLambdaQueryWrapper.eq(SysRole::getRoleId, (Object)roleId);
        sysRoleLambdaQueryWrapper.select(new SFunction[]{SysRole::getDataScopeType});
        SysRole sysRole = (SysRole)((Object)this.getOne((Wrapper)sysRoleLambdaQueryWrapper, false));
        if (sysRole != null && (dataScopeType = sysRole.getDataScopeType()) != null) {
            return dataScopeType;
        }
        return DataScopeTypeEnum.SELF.getCode();
    }

    @Override
    public void updateRoleDataScopeType(Long roleId, Integer dataScopeType) {
        if (ObjectUtil.isEmpty((Object)roleId) || ObjectUtil.isEmpty((Object)dataScopeType)) {
            return;
        }
        LambdaUpdateWrapper sysRoleLambdaUpdateWrapper = new LambdaUpdateWrapper();
        sysRoleLambdaUpdateWrapper.eq(SysRole::getRoleId, (Object)roleId);
        sysRoleLambdaUpdateWrapper.set(SysRole::getDataScopeType, (Object)dataScopeType);
        this.update((Wrapper)sysRoleLambdaUpdateWrapper);
    }

    @Override
    public DataScopeTypeEnum getRoleDataScope(List<Long> roleIds) {
        Integer dataScopeType;
        LambdaQueryWrapper sysRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLambdaQueryWrapper.in(SysRole::getRoleId, roleIds);
        sysRoleLambdaQueryWrapper.select(new SFunction[]{SysRole::getDataScopeType});
        sysRoleLambdaQueryWrapper.orderByDesc(SysRole::getDataScopeType);
        List sysRoleList = this.list((Wrapper)sysRoleLambdaQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)sysRoleList) && (dataScopeType = ((SysRole)((Object)sysRoleList.get(0))).getDataScopeType()) != null) {
            return DataScopeTypeEnum.codeToEnum((Integer)dataScopeType);
        }
        return DataScopeTypeEnum.SELF;
    }

    @Override
    public List<SysRole> userAssignRoleList(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper<SysRole> wrapper = this.createWrapper(sysRoleRequest);
        boolean superAdminFlag = LoginContext.me().getSuperAdminFlag();
        if (!superAdminFlag) {
            return new ArrayList<SysRole>();
        }
        wrapper.eq(SysRole::getRoleType, (Object)RoleTypeEnum.SYSTEM_ROLE.getCode());
        wrapper.select(new SFunction[]{SysRole::getRoleId, SysRole::getRoleName, SysRole::getRoleType});
        return this.list((Wrapper)wrapper);
    }

    @Override
    public void refreshRoleAuth(Set<Long> roleIdList, Set<Long> menuIdList, Set<Long> menuOptionIdList) {
        List<SysMenu> totalMenus = this.sysMenuService.getTotalMenus(menuIdList);
        List<SysMenuOptions> totalMenuOptionsList = this.sysMenuOptionsService.getTotalMenuOptionsList(menuOptionIdList);
        for (Long roleId : roleIdList) {
            this.sysRoleMenuService.bindRoleMenus(roleId, totalMenus);
            this.sysRoleMenuOptionsService.bindRoleMenuOptions(roleId, totalMenuOptionsList);
            this.sysRoleLimitService.updateRoleLimit(roleId, menuIdList, menuOptionIdList);
        }
    }

    @Override
    public List<SysRole> getRoleDataScopeType(List<Long> roleIdList) {
        if (ObjectUtil.isEmpty(roleIdList)) {
            return new ArrayList<SysRole>();
        }
        LambdaQueryWrapper sysRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLambdaQueryWrapper.in(SysRole::getRoleId, roleIdList);
        sysRoleLambdaQueryWrapper.select(new SFunction[]{SysRole::getRoleId, SysRole::getDataScopeType});
        return this.list((Wrapper)sysRoleLambdaQueryWrapper);
    }

    @Override
    public List<SysRole> permissionGetRoleList(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper<SysRole> wrapper = this.createWrapper(sysRoleRequest);
        wrapper.select(new SFunction[]{SysRole::getRoleId, SysRole::getRoleName});
        this.filterRolePermission(wrapper, sysRoleRequest);
        return this.list((Wrapper)wrapper);
    }

    public Long getDefaultRoleId() {
        LambdaQueryWrapper sysRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLambdaQueryWrapper.eq(SysRole::getRoleCode, (Object)"employee");
        sysRoleLambdaQueryWrapper.select(new SFunction[]{SysRole::getRoleId});
        SysRole sysRole = (SysRole)((Object)this.getOne((Wrapper)sysRoleLambdaQueryWrapper, false));
        if (sysRole != null) {
            return sysRole.getRoleId();
        }
        return null;
    }

    public String getRoleNameByRoleId(Long roleId) {
        if (ObjectUtil.isEmpty((Object)roleId)) {
            return "";
        }
        LambdaQueryWrapper sysRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLambdaQueryWrapper.eq(SysRole::getRoleId, (Object)roleId);
        sysRoleLambdaQueryWrapper.select(new SFunction[]{SysRole::getRoleName});
        SysRole sysRole = (SysRole)((Object)this.getOne((Wrapper)sysRoleLambdaQueryWrapper, false));
        if (sysRole != null) {
            return sysRole.getRoleName();
        }
        return "";
    }

    public List<String> getRoleMenuOptionsByRoleId(String roleCode) {
        if (ObjectUtil.isEmpty((Object)roleCode)) {
            return new ArrayList<String>();
        }
        LambdaQueryWrapper sysRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLambdaQueryWrapper.eq(SysRole::getRoleCode, (Object)roleCode);
        sysRoleLambdaQueryWrapper.select(new SFunction[]{SysRole::getRoleId});
        SysRole sysRole = (SysRole)((Object)this.getOne((Wrapper)sysRoleLambdaQueryWrapper, false));
        if (sysRole == null) {
            return new ArrayList<String>();
        }
        Long roleId = sysRole.getRoleId();
        List<Long> roleBindMenuOptionsIdList = this.sysRoleMenuOptionsService.getRoleBindMenuOptionsIdList(ListUtil.list((boolean)false, (Object[])new Long[]{roleId}));
        if (ObjectUtil.isEmpty(roleBindMenuOptionsIdList)) {
            return new ArrayList<String>();
        }
        return this.sysMenuOptionsService.getOptionsCodeList(roleBindMenuOptionsIdList);
    }

    public List<SysRoleDTO> getRolesByIds(List<Long> roleIds) {
        if (ObjectUtil.isEmpty(roleIds)) {
            return new ArrayList<SysRoleDTO>();
        }
        LambdaQueryWrapper sysRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLambdaQueryWrapper.in(SysRole::getRoleId, roleIds);
        sysRoleLambdaQueryWrapper.select(new SFunction[]{SysRole::getRoleName, SysRole::getRoleId, SysRole::getRoleCode, SysRole::getRoleType, SysRole::getRoleCompanyId});
        List sysRoleList = this.list((Wrapper)sysRoleLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)sysRoleList)) {
            return new ArrayList<SysRoleDTO>();
        }
        return BeanUtil.copyToList((Collection)sysRoleList, SysRoleDTO.class, (CopyOptions)CopyOptions.create().ignoreError());
    }

    public List<SysRoleDTO> getBusinessRoleAndCompanyRole(List<Long> companyIdList) {
        if (ObjectUtil.isEmpty(companyIdList)) {
            return new ArrayList<SysRoleDTO>();
        }
        LambdaQueryWrapper sysRoleLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleLambdaQueryWrapper.eq(SysRole::getRoleType, (Object)RoleTypeEnum.BUSINESS_ROLE.getCode());
        ((LambdaQueryWrapper)sysRoleLambdaQueryWrapper.or()).nested(i -> ((LambdaQueryWrapper)i.eq(SysRole::getRoleType, (Object)RoleTypeEnum.COMPANY_ROLE.getCode())).and(j -> j.in(SysRole::getRoleCompanyId, (Collection)companyIdList)));
        sysRoleLambdaQueryWrapper.select(new SFunction[]{SysRole::getRoleId, SysRole::getRoleName, SysRole::getRoleType, SysRole::getRoleCompanyId});
        sysRoleLambdaQueryWrapper.orderByAsc(SysRole::getRoleType);
        List sysRoleList = this.list((Wrapper)sysRoleLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)sysRoleList)) {
            return new ArrayList<SysRoleDTO>();
        }
        return BeanUtil.copyToList((Collection)sysRoleList, SysRoleDTO.class, (CopyOptions)CopyOptions.create().ignoreError());
    }

    private SysRole querySysRole(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = (SysRole)((Object)this.getById(sysRoleRequest.getRoleId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysRole))) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.SYS_ROLE_NOT_EXISTED);
        }
        return sysRole;
    }

    private LambdaQueryWrapper<SysRole> createWrapper(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = sysRoleRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.nested(i -> ((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SysRole::getRoleName, (Object)searchText)).or()).like(SysRole::getRoleCode, (Object)searchText));
        }
        queryWrapper.orderByAsc(SysRole::getRoleType);
        queryWrapper.orderByAsc(SysRole::getRoleSort);
        return queryWrapper;
    }

    private void baseDelete(Set<Long> roleIdList) {
        Map callbackApiMap = SpringUtil.getBeansOfType(RemoveRoleCallbackApi.class);
        for (RemoveRoleCallbackApi removeRoleCallbackApi : callbackApiMap.values()) {
            removeRoleCallbackApi.validateHaveRoleBind(roleIdList);
        }
        for (RemoveRoleCallbackApi removeRoleCallbackApi : callbackApiMap.values()) {
            removeRoleCallbackApi.removeRoleAction(roleIdList);
        }
        this.removeBatchByIds(roleIdList);
    }

    private void filterRolePermission(LambdaQueryWrapper<SysRole> wrapper, SysRoleRequest sysRoleRequest) {
        boolean superAdminFlag = LoginContext.me().getSuperAdminFlag();
        if (superAdminFlag) {
            if (ObjectUtil.isNotEmpty((Object)sysRoleRequest.getRoleType())) {
                wrapper.eq(SysRole::getRoleType, (Object)sysRoleRequest.getRoleType());
            }
            if (ObjectUtil.isNotEmpty((Object)sysRoleRequest.getRoleCompanyId())) {
                wrapper.eq(SysRole::getRoleCompanyId, (Object)sysRoleRequest.getRoleCompanyId());
            }
            return;
        }
        wrapper.eq(SysRole::getRoleType, (Object)RoleTypeEnum.COMPANY_ROLE.getCode());
        wrapper.eq(SysRole::getRoleCompanyId, (Object)LoginContext.me().getCurrentUserCompanyId());
    }

    private void rolePermissionValidate(SysRoleRequest sysRoleRequest) {
        boolean superAdminFlag = LoginContext.me().getSuperAdminFlag();
        if (superAdminFlag) {
            return;
        }
        if (!RoleTypeEnum.COMPANY_ROLE.getCode().equals(sysRoleRequest.getRoleType())) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.ROLE_TYPE_ERROR);
        }
        if (!LoginContext.me().getCurrentUserCompanyId().equals(sysRoleRequest.getRoleCompanyId())) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.ROLE_COMPANY_ERROR);
        }
    }
}

