/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.theme.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.file.api.FileInfoApi;
import cn.stylefeng.roses.kernel.file.api.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.api.pojo.AntdvFileInfo;
import cn.stylefeng.roses.kernel.file.api.pojo.request.SysFileInfoRequest;
import cn.stylefeng.roses.kernel.rule.callback.ConfigUpdateCallback;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.exception.SysException;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysTheme;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysThemeTemplate;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysThemeTemplateField;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysThemeTemplateRel;
import cn.stylefeng.roses.kernel.sys.modular.theme.enums.ThemeFieldTypeEnum;
import cn.stylefeng.roses.kernel.sys.modular.theme.exceptions.SysThemeExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.theme.factory.DefaultThemeFactory;
import cn.stylefeng.roses.kernel.sys.modular.theme.mapper.SysThemeMapper;
import cn.stylefeng.roses.kernel.sys.modular.theme.pojo.DefaultTheme;
import cn.stylefeng.roses.kernel.sys.modular.theme.pojo.SysThemeDTO;
import cn.stylefeng.roses.kernel.sys.modular.theme.pojo.SysThemeRequest;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeService;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeTemplateFieldService;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeTemplateRelService;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeTemplateService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysThemeServiceImpl
extends ServiceImpl<SysThemeMapper, SysTheme>
implements SysThemeService,
ConfigUpdateCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysThemeServiceImpl.class);
    @Resource
    private SysThemeTemplateService sysThemeTemplateService;
    @Resource
    private SysThemeTemplateFieldService sysThemeTemplateFieldService;
    @Resource
    private FileInfoApi fileInfoApi;
    @Resource(name="themeCacheApi")
    private CacheOperatorApi<DefaultTheme> themeCacheApi;
    @Resource
    private SysThemeTemplateRelService sysThemeTemplateRelService;

    @Override
    public void add(SysThemeRequest sysThemeRequest) {
        SysThemeTemplate sysThemeTemplate = (SysThemeTemplate)((Object)this.sysThemeTemplateService.getById(sysThemeRequest.getTemplateId()));
        if (YesOrNotEnum.N.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            throw new SysException((AbstractExceptionEnum)SysThemeExceptionEnum.THEME_TEMPLATE_IS_DISABLE);
        }
        SysTheme sysTheme = new SysTheme();
        BeanUtil.copyProperties((Object)((Object)sysThemeRequest), (Object)((Object)sysTheme), (String[])new String[0]);
        sysTheme.setStatusFlag(Character.valueOf(YesOrNotEnum.N.getCode().charAt(0)));
        this.save((Object)sysTheme);
    }

    @Override
    public void del(SysThemeRequest sysThemeRequest) {
        SysTheme sysTheme = this.querySysThemeById(sysThemeRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysTheme.getStatusFlag().toString())) {
            throw new SysException((AbstractExceptionEnum)SysThemeExceptionEnum.THEME_NOT_ALLOW_DELETE);
        }
        String themeValue = sysTheme.getThemeValue();
        Map themeMap = (Map)JSON.parseObject((String)themeValue, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        ArrayList themeKeys = new ArrayList(themeMap.keySet());
        List<Object> fileNames = new ArrayList();
        if (themeKeys.size() > 0) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(SysThemeTemplateField::getFieldCode, themeKeys)).eq(SysThemeTemplateField::getFieldType, (Object)ThemeFieldTypeEnum.FILE.getCode())).select(new SFunction[]{SysThemeTemplateField::getFieldCode});
            List sysThemeTemplateFields = this.sysThemeTemplateFieldService.list((Wrapper)queryWrapper);
            fileNames = sysThemeTemplateFields.stream().map(SysThemeTemplateField::getFieldCode).collect(Collectors.toList());
        }
        if (fileNames.size() > 0) {
            for (String themeKey : themeKeys) {
                String themeValueStr = (String)themeMap.get(themeKey);
                for (String fileName : fileNames) {
                    if (!StrUtil.isNotBlank((CharSequence)themeKey) || !StrUtil.isNotBlank((CharSequence)fileName) || !themeKey.equals(fileName)) continue;
                    SysFileInfoRequest sysFileInfoRequest = new SysFileInfoRequest();
                    sysFileInfoRequest.setFileId(Long.valueOf(Long.parseLong(themeValueStr)));
                    this.fileInfoApi.deleteReally(sysFileInfoRequest);
                }
            }
        }
        this.removeById((Object)sysTheme);
        this.clearThemeCache();
    }

    @Override
    public void edit(SysThemeRequest sysThemeRequest) {
        SysTheme sysTheme = new SysTheme();
        BeanUtil.copyProperties((Object)((Object)sysThemeRequest), (Object)((Object)sysTheme), (String[])new String[0]);
        this.updateById((Object)sysTheme);
        this.clearThemeCache();
    }

    @Override
    public PageResult<SysThemeDTO> findPage(SysThemeRequest sysThemeRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)sysThemeRequest.getThemeName()), SysTheme::getThemeName, (Object)sysThemeRequest.getThemeName());
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        ArrayList<SysThemeDTO> sysThemeDTOList = new ArrayList<SysThemeDTO>();
        for (SysTheme record : page.getRecords()) {
            SysThemeDTO sysThemeDTO = new SysThemeDTO();
            BeanUtil.copyProperties((Object)((Object)record), (Object)sysThemeDTO, (String[])new String[0]);
            SysThemeTemplate sysThemeTemplate = (SysThemeTemplate)((Object)this.sysThemeTemplateService.getById(record.getTemplateId()));
            sysThemeDTO.setTemplateName(sysThemeTemplate.getTemplateName());
            sysThemeDTOList.add(sysThemeDTO);
        }
        return PageResultFactory.createPageResult(sysThemeDTOList, (Long)page.getTotal(), (Integer)Integer.valueOf(String.valueOf(page.getSize())), (Integer)Integer.valueOf(String.valueOf(page.getCurrent())));
    }

    @Override
    public SysTheme detail(SysThemeRequest sysThemeRequest) {
        SysTheme sysTheme = this.querySysThemeById(sysThemeRequest);
        String themeValueJson = sysTheme.getThemeValue();
        Map jsonObject = (Map)JSON.parseObject((String)themeValueJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        sysTheme.setDynamicForm(jsonObject);
        HashMap<String, AntdvFileInfo[]> tempFileList = new HashMap<String, AntdvFileInfo[]>();
        for (Map.Entry keyValues : jsonObject.entrySet()) {
            String key = (String)keyValues.getKey();
            String value = String.valueOf(jsonObject.get(key));
            boolean keyFileFlag = this.sysThemeTemplateFieldService.getKeyFileFlag(key);
            if (!keyFileFlag) continue;
            AntdvFileInfo antdvFileInfo = this.fileInfoApi.buildAntdvFileInfo(Long.valueOf(value));
            tempFileList.put(key, new AntdvFileInfo[]{antdvFileInfo});
        }
        sysTheme.setTempFileList(tempFileList);
        return sysTheme;
    }

    @Override
    public void updateThemeStatus(SysThemeRequest sysThemeRequest) {
        SysTheme sysTheme = this.querySysThemeById(sysThemeRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysTheme.getStatusFlag().toString())) {
            throw new SysException((AbstractExceptionEnum)SysThemeExceptionEnum.UNIQUE_ENABLE_NOT_DISABLE);
        }
        sysTheme.setStatusFlag(Character.valueOf(YesOrNotEnum.Y.getCode().charAt(0)));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysTheme::getStatusFlag, (Object)Character.valueOf(YesOrNotEnum.Y.getCode().charAt(0)));
        if (this.list().size() > 1) {
            SysTheme theme = (SysTheme)((Object)this.getOne((Wrapper)queryWrapper, true));
            theme.setStatusFlag(Character.valueOf(YesOrNotEnum.N.getCode().charAt(0)));
            this.updateById((Object)theme);
        }
        this.updateById((Object)sysTheme);
        this.clearThemeCache();
    }

    @Override
    public DefaultTheme currentThemeInfo(SysThemeRequest sysThemeParam) {
        DefaultTheme defaultTheme = (DefaultTheme)this.themeCacheApi.get("GUNS_PLATFORM");
        if (defaultTheme != null) {
            return defaultTheme;
        }
        DefaultTheme result = this.querySystemTheme();
        this.parseFileUrls(result);
        this.themeCacheApi.put("GUNS_PLATFORM", (Object)result, FileConfigExpander.getDefaultFileTimeoutSeconds());
        return result;
    }

    public void configUpdate(String code, String value) {
        if ("SYS_SERVER_DEPLOY_HOST".equals(code)) {
            this.clearThemeCache();
        }
    }

    private SysTheme querySysThemeById(SysThemeRequest sysThemeRequest) {
        SysTheme sysTheme = (SysTheme)((Object)this.getById(sysThemeRequest.getThemeId()));
        if (ObjectUtil.isNull((Object)((Object)sysTheme))) {
            throw new SysException((AbstractExceptionEnum)SysThemeExceptionEnum.THEME_NOT_EXIST);
        }
        return sysTheme;
    }

    private DefaultTheme querySystemTheme() {
        Long defaultTemplateId = this.getDefaultTemplateId();
        if (defaultTemplateId == null) {
            return DefaultThemeFactory.getSystemDefaultTheme();
        }
        LambdaQueryWrapper sysThemeLambdaQueryWrapper = new LambdaQueryWrapper();
        sysThemeLambdaQueryWrapper.eq(SysTheme::getTemplateId, (Object)defaultTemplateId);
        sysThemeLambdaQueryWrapper.eq(SysTheme::getStatusFlag, (Object)YesOrNotEnum.Y.getCode());
        sysThemeLambdaQueryWrapper.orderByDesc(BaseEntity::getCreateTime);
        SysTheme sysTheme = (SysTheme)((Object)this.getOne((Wrapper)sysThemeLambdaQueryWrapper, false));
        if (sysTheme == null) {
            log.error("\u5f53\u524d\u7cfb\u7edf\u4e3b\u9898\u6a21\u677f\u7f16\u7801\u4e3aGUNS_PLATFORM\u7684\u4e3b\u9898\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u6570\u636e\u662f\u5426\u6b63\u5e38\uff01");
            return DefaultThemeFactory.getSystemDefaultTheme();
        }
        String themeValue = sysTheme.getThemeValue();
        if (StrUtil.isNotBlank((CharSequence)themeValue)) {
            JSONObject jsonObject = JSONObject.parseObject((String)themeValue);
            return DefaultThemeFactory.parseDefaultTheme(jsonObject);
        }
        return DefaultThemeFactory.getSystemDefaultTheme();
    }

    private DefaultTheme parseFileUrls(DefaultTheme theme) {
        Long defaultTemplateId = this.getDefaultTemplateId();
        if (defaultTemplateId == null) {
            return theme;
        }
        LambdaQueryWrapper sysThemeTemplateRelLambdaQueryWrapper = new LambdaQueryWrapper();
        sysThemeTemplateRelLambdaQueryWrapper.eq(SysThemeTemplateRel::getTemplateId, (Object)defaultTemplateId);
        List relList = this.sysThemeTemplateRelService.list((Wrapper)sysThemeTemplateRelLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)relList)) {
            return theme;
        }
        List fieldCodes = relList.stream().map(SysThemeTemplateRel::getFieldCode).collect(Collectors.toList());
        LambdaQueryWrapper sysThemeTemplateFieldLambdaQueryWrapper = new LambdaQueryWrapper();
        sysThemeTemplateFieldLambdaQueryWrapper.in(SysThemeTemplateField::getFieldCode, fieldCodes);
        sysThemeTemplateFieldLambdaQueryWrapper.eq(SysThemeTemplateField::getFieldType, (Object)ThemeFieldTypeEnum.FILE.getCode());
        sysThemeTemplateFieldLambdaQueryWrapper.select(new SFunction[]{SysThemeTemplateField::getFieldCode});
        List fieldInfoList = this.sysThemeTemplateFieldService.list((Wrapper)sysThemeTemplateFieldLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)fieldInfoList)) {
            return theme;
        }
        List needToParse = fieldInfoList.stream().map(SysThemeTemplateField::getFieldCode).map(CharSequenceUtil::toCamelCase).collect(Collectors.toList());
        Map<String, String> otherConfigs = theme.getOtherConfigs();
        for (String fieldName : needToParse) {
            PropertyDescriptor propertyDescriptor = null;
            try {
                propertyDescriptor = new PropertyDescriptor(fieldName, DefaultTheme.class);
                Method readMethod = propertyDescriptor.getReadMethod();
                String fieldValue = (String)readMethod.invoke((Object)theme, new Object[0]);
                if (!StrUtil.isEmpty((CharSequence)fieldValue)) {
                    String fileUnAuthUrl = this.fileInfoApi.getFileUnAuthUrl(Long.valueOf(fieldValue));
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    writeMethod.invoke((Object)theme, fileUnAuthUrl);
                }
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u4e3b\u9898\u7684\u6587\u4ef6id\u4e3aurl\u65f6\u51fa\u9519", (Throwable)e);
            }
            for (Map.Entry<String, String> otherItem : otherConfigs.entrySet()) {
                if (!fieldName.equals(otherItem.getKey())) continue;
                String otherFileId = otherItem.getValue();
                String fileUnAuthUrl = this.fileInfoApi.getFileUnAuthUrl(Long.valueOf(otherFileId));
                otherConfigs.put(otherItem.getKey(), fileUnAuthUrl);
            }
        }
        return theme;
    }

    private Long getDefaultTemplateId() {
        LambdaQueryWrapper sysThemeTemplateLambdaQueryWrapper = new LambdaQueryWrapper();
        sysThemeTemplateLambdaQueryWrapper.eq(SysThemeTemplate::getTemplateCode, (Object)"GUNS_PLATFORM");
        SysThemeTemplate sysThemeTemplate = (SysThemeTemplate)((Object)this.sysThemeTemplateService.getOne((Wrapper)sysThemeTemplateLambdaQueryWrapper, false));
        if (sysThemeTemplate == null) {
            log.error("\u5f53\u524d\u7cfb\u7edf\u4e3b\u9898\u6a21\u677f\u7f16\u7801GUNS_PLATFORM\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u6570\u636e\u662f\u5426\u6b63\u5e38\uff01");
            return null;
        }
        return sysThemeTemplate.getTemplateId();
    }

    private void clearThemeCache() {
        this.themeCacheApi.remove(new String[]{"GUNS_PLATFORM"});
    }
}

