/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.validator.api.validators.unique;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.validator.api.context.RequestGroupContext;
import cn.stylefeng.roses.kernel.validator.api.context.RequestParamContext;
import cn.stylefeng.roses.kernel.validator.api.pojo.UniqueValidateParam;
import cn.stylefeng.roses.kernel.validator.api.validators.unique.TableUniqueValue;
import cn.stylefeng.roses.kernel.validator.api.validators.unique.service.TableUniqueValueService;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

public class TableUniqueValueValidator
implements ConstraintValidator<TableUniqueValue, Object> {
    private String tableName;
    private String columnName;
    private String idFieldName;
    private boolean excludeLogicDeleteItems;
    private String logicDeleteFieldName;
    private String logicDeleteValue;

    public void initialize(TableUniqueValue constraintAnnotation) {
        this.tableName = constraintAnnotation.tableName();
        this.columnName = constraintAnnotation.columnName();
        this.excludeLogicDeleteItems = constraintAnnotation.excludeLogicDeleteItems();
        this.logicDeleteFieldName = constraintAnnotation.logicDeleteFieldName();
        this.logicDeleteValue = constraintAnnotation.logicDeleteValue();
        this.idFieldName = constraintAnnotation.idFieldName();
    }

    public boolean isValid(Object fieldValue, ConstraintValidatorContext context) {
        if (ObjectUtil.isNull((Object)fieldValue)) {
            return true;
        }
        Class validateGroupClass = RequestGroupContext.get();
        if (BaseRequest.edit.class.equals((Object)validateGroupClass)) {
            UniqueValidateParam editParam = this.createEditParam(fieldValue);
            return TableUniqueValueService.getFiledUniqueFlag(editParam);
        }
        if (BaseRequest.add.class.equals((Object)validateGroupClass)) {
            UniqueValidateParam addParam = this.createAddParam(fieldValue);
            return TableUniqueValueService.getFiledUniqueFlag(addParam);
        }
        UniqueValidateParam addParam = this.createAddParam(fieldValue);
        return TableUniqueValueService.getFiledUniqueFlag(addParam);
    }

    private UniqueValidateParam createAddParam(Object fieldValue) {
        return UniqueValidateParam.builder().tableName(this.tableName).columnName(this.columnName).value(fieldValue).excludeCurrentRecord(Boolean.FALSE).excludeLogicDeleteItems(Boolean.valueOf(this.excludeLogicDeleteItems)).logicDeleteFieldName(this.logicDeleteFieldName).logicDeleteValue(this.logicDeleteValue).build();
    }

    private UniqueValidateParam createEditParam(Object fieldValue) {
        Dict requestParam = RequestParamContext.get();
        String camelCaseIdFieldName = StrUtil.toCamelCase((CharSequence)this.idFieldName);
        return UniqueValidateParam.builder().tableName(this.tableName).columnName(this.columnName).value(fieldValue).idFieldName(this.idFieldName).excludeCurrentRecord(Boolean.TRUE).id(requestParam.getLong(camelCaseIdFieldName)).excludeLogicDeleteItems(Boolean.valueOf(this.excludeLogicDeleteItems)).logicDeleteFieldName(this.logicDeleteFieldName).logicDeleteValue(this.logicDeleteValue).build();
    }
}

