/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.api.base.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class WebAPIResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SUCCESS = 1;
    public static final int FAIL = 0;
    public static final int WARN = 2;
    public static final int ERROR = -1;
    public static final int TIMEOUT = -2;
    private int result = 1;
    private String message = "";
    private String cause = "";
    private Map<String, Object> vars = new HashMap<String, Object>();
    private Object data;

    public WebAPIResult() {
    }

    public WebAPIResult(int result) {
        this.result = result;
    }

    public WebAPIResult(int result, String message) {
        this.result = result;
        this.message = message;
    }

    public WebAPIResult(int result, String message, String cause) {
        this.result = result;
        this.message = message;
        this.cause = cause;
    }

    public void addVariable(String key, Object value) {
        this.vars.put(key, value);
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return 1 == this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public Object getVar(String key) {
        if (null == this.vars) {
            return null;
        }
        return this.vars.get(key);
    }

    public Map<String, Object> getVars() {
        return this.vars;
    }

    public void setVars(Map<String, Object> vars) {
        this.vars = vars;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        SimpleDateFormat myDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:dd");
        mapper.setDateFormat((DateFormat)myDateFormat);
        mapper.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "{}";
        }
    }
}

