/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.api.bo.constants;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum BoState {
    NEW("new", "\u65b0\u5efa", "#FF0033"),
    EXIST("exist", "\u73b0\u6709", "#336633");

    private final String value;
    private final String label;
    private final String color;

    private BoState(String value, String label, String color) {
        this.value = value;
        this.label = label;
        this.color = color;
    }

    public String getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getColor() {
        return this.color;
    }

    public static String getLabel(String value) {
        for (BoState vl : BoState.values()) {
            if (!vl.value.equals(value)) continue;
            return vl.label;
        }
        return value;
    }

    public static BoState get(String value) {
        for (BoState p : BoState.values()) {
            if (!p.getValue().equals(value)) continue;
            return p;
        }
        return null;
    }

    public String toString() {
        return this.getValue();
    }

    public static List<BoState> list() {
        return new ArrayList<BoState>(Arrays.asList(BoState.values()));
    }
}

