/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.api.bo.constants;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum FieldDataFormat {
    PHONE("phone", "^(((\\d{2,3}))|(\\d{3}-))?1\\d{10}$", "\u624b\u673a\u53f7"),
    TELEPHONE("telephone", "^(((0[0-9]{2,3}))|(0[0-9]{2,3})\\-)?([2-9][0-9]{6,7})(\\-[0-9]{1,4})?$", "\u7535\u8bdd\u53f7\u7801"),
    ZIP("zip", "^\\d{6}$", "\u90ae\u7f16"),
    IDCARD("idcard", "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)", "\u8eab\u4efd\u8bc1\u53f7"),
    EMAIL("email", "^([a-zA-Z0-9_.-])+@(([a-zA-Z0-9-])+.)+([a-zA-Z0-9]{2,4})+$", "\u90ae\u7bb1");

    private String key;
    private String reg;
    private String label;

    private FieldDataFormat(String key, String reg, String label) {
        this.key = key;
        this.reg = reg;
        this.label = label;
    }

    public String key() {
        return this.key;
    }

    public String reg() {
        return this.reg;
    }

    public String label() {
        return this.label;
    }

    public static FieldDataFormat fromKey(String key) {
        for (FieldDataFormat c : FieldDataFormat.values()) {
            if (!c.key().equalsIgnoreCase(key)) continue;
            return c;
        }
        return null;
    }
}

