/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.codegen.builder;

import com.lc.ibps.base.core.util.AppUtil;
import com.lc.ibps.base.core.util.json.JsonUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.components.codegen.model.ColumnModel;
import com.lc.ibps.components.codegen.model.TableModel;
import com.lc.ibps.components.codegen.persistence.entity.FieldConfigPo;
import com.lc.ibps.components.codegen.persistence.entity.TableConfigPo;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class TableModelBuilder {
    public static TableModel build(TableConfigPo tableConfig) {
        TableModel tableModel = new TableModel();
        ArrayList<ColumnModel> columnModelList = new ArrayList<ColumnModel>();
        ColumnModel columnModel = null;
        tableModel.setTableName(tableConfig.getTableName());
        if (StringUtil.isNotEmpty((CharSequence)tableConfig.getBoId())) {
            tableModel.setBoId(tableConfig.getBoId());
        }
        tableModel.setTabComment(tableConfig.getTableComment());
        tableModel.setLayerTemplate(tableConfig.getLayerTemplate());
        tableModel.setSub(StringUtil.isNotEmpty((CharSequence)tableConfig.getParentTableName()));
        String c = AppUtil.getProperty((String)"business.table.upperorlower");
        if (c.equals("lower")) {
            tableModel.setProfix(AppUtil.getProperty((String)"business.table.profix").toLowerCase());
        } else {
            tableModel.setProfix(AppUtil.getProperty((String)"business.table.profix").toUpperCase());
        }
        if (StringUtil.isNotEmpty((CharSequence)tableConfig.getForeignKey())) {
            tableModel.setForeignKey(tableConfig.getForeignKey());
        }
        if (StringUtil.isNotEmpty((CharSequence)tableConfig.getFromKey())) {
            tableModel.setFromKey(tableConfig.getFromKey());
        }
        if (StringUtil.isNotEmpty((CharSequence)tableConfig.getRelation())) {
            tableModel.setRelation(tableConfig.getRelation());
        }
        tableModel.setColumnList(columnModelList);
        for (FieldConfigPo fieldConfig : tableConfig.getFieldConfigPoList()) {
            columnModel = new ColumnModel();
            columnModel.setColumnName(fieldConfig.getField());
            columnModel.setColName(fieldConfig.getPropName());
            columnModel.setComment(fieldConfig.getFieldComment());
            columnModel.setColType(fieldConfig.getJavaType());
            columnModel.setColDbType(fieldConfig.getSqlType());
            columnModel.setControl(fieldConfig.getControl());
            columnModel.setLength(fieldConfig.getLength());
            columnModel.setPrecision(fieldConfig.getPrecision());
            columnModel.setScale(fieldConfig.getScale());
            columnModel.setIsPK("pk".equalsIgnoreCase(fieldConfig.getKeyName()));
            columnModel.setIsList("Y".equalsIgnoreCase(fieldConfig.getShowList()));
            columnModel.setIsQuery("Y".equalsIgnoreCase(fieldConfig.getShowQuery()));
            columnModel.setIsNotNull("N".equalsIgnoreCase(fieldConfig.getIsNull()));
            columnModel.setDefaultValue(fieldConfig.getDefaultValue());
            columnModelList.add(columnModel);
        }
        return tableModel;
    }

    public static void build(TableModel tableModel, JSONObject data) {
        List commonList = tableModel.getCommonList();
        JSONArray fields = data.getJSONArray("fields");
        block0: for (ColumnModel column : commonList) {
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                JSONObject field = fields.getJSONObject(i);
                if (JsonUtil.isEmpty((Object)field.get("name")) || !field.getString("name").equals(column.getColName())) continue;
                column.setControl(field.getString("field_type"));
                column.setParamsJson(field.getString("field_options"));
                if (!JsonUtil.isJsonObject((Object)field.getString("field_options"))) continue block0;
                column.setParamsMap(JsonUtil.getMapFromJson((String)field.getString("field_options")));
                continue block0;
            }
        }
    }
}

