/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.codegen.domain;

import com.lc.ibps.api.form.constants.FormMode;
import com.lc.ibps.api.form.service.IFormbuilderStrategy;
import com.lc.ibps.base.core.engine.freemarker.FreemarkerEngine;
import com.lc.ibps.base.core.loader.IbpsClassLoader;
import com.lc.ibps.base.core.util.AppUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.ClassUtil;
import com.lc.ibps.base.core.util.FileUtil;
import com.lc.ibps.base.core.util.json.JsonUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.base.core.util.time.DateUtil;
import com.lc.ibps.base.db.mybatis.spring.MybatisSqlSessionFactoryBean;
import com.lc.ibps.base.framework.domain.AbstractDomain;
import com.lc.ibps.base.framework.persistence.entity.PO;
import com.lc.ibps.base.web.util.AppFileUtil;
import com.lc.ibps.components.codegen.builder.TableModelBuilder;
import com.lc.ibps.components.codegen.model.TableModel;
import com.lc.ibps.components.codegen.persistence.dao.SchemeDao;
import com.lc.ibps.components.codegen.persistence.dao.SchemeParamDao;
import com.lc.ibps.components.codegen.persistence.entity.DoTypePo;
import com.lc.ibps.components.codegen.persistence.entity.SchemeParamPo;
import com.lc.ibps.components.codegen.persistence.entity.SchemePo;
import com.lc.ibps.components.codegen.persistence.entity.TemplatePo;
import com.lc.ibps.components.codegen.persistence.entity.VariablePo;
import com.lc.ibps.components.codegen.repository.DoTypeRepository;
import com.lc.ibps.components.codegen.repository.SchemeRepository;
import com.lc.ibps.components.codegen.repository.TemplateRepository;
import com.lc.ibps.components.codegen.repository.VariableRepository;
import com.lc.ibps.components.codegen.service.ITableModelService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class Scheme
extends AbstractDomain<String, SchemePo> {
    private SchemeDao schemeDao = null;
    private SchemeParamDao schemeParamDao = null;
    private SchemeRepository schemeRepository = null;
    private VariableRepository variableRepository = null;
    private TemplateRepository templateRepository = null;
    private DoTypeRepository doTypeRepository = null;
    private ITableModelService tableModelService = null;
    private FreemarkerEngine freemarkerEngine = null;
    private IFormbuilderStrategy formbuilderStrategy = null;

    protected void init() {
        this.schemeDao = (SchemeDao)AppUtil.getBean(SchemeDao.class);
        this.schemeParamDao = (SchemeParamDao)AppUtil.getBean(SchemeParamDao.class);
        this.schemeRepository = (SchemeRepository)AppUtil.getBean(SchemeRepository.class);
        this.variableRepository = (VariableRepository)AppUtil.getBean(VariableRepository.class);
        this.doTypeRepository = (DoTypeRepository)AppUtil.getBean(DoTypeRepository.class);
        this.templateRepository = (TemplateRepository)AppUtil.getBean(TemplateRepository.class);
        this.tableModelService = (ITableModelService)AppUtil.getBean(ITableModelService.class);
        this.freemarkerEngine = (FreemarkerEngine)AppUtil.getBean(FreemarkerEngine.class);
        this.setDao(this.schemeDao);
    }

    public void saveCascade() {
        this.save();
        if (((SchemePo)this.getData()).isDelBeforeSave()) {
            this.schemeParamDao.deleteByMainId((String)((Object)this.getId()));
        }
        for (SchemeParamPo po : ((SchemePo)this.getData()).getSchemeParamPoList()) {
            po.setId(null);
            po.setParentId((String)((Object)this.getId()));
            this.schemeParamDao.create((Object)po);
        }
    }

    public void deleteByIdsCascade(String[] ids) {
        for (String id : ids) {
            this.schemeParamDao.deleteByMainId(id);
        }
        this.deleteByIds((Serializable[])ids);
    }

    public Map<String, String> gen(String[] ids, String cuser) throws Exception {
        HashMap<String, String> rsMap = new HashMap<String, String>();
        String fileName = "codegen_" + System.currentTimeMillis();
        String codeDirPath = StringUtil.trimSuffix((String)AppFileUtil.ATTACH_PATH, (String)File.separator) + File.separator + "codegen" + File.separator + fileName;
        rsMap.put("filePath", "codegen" + File.separator + fileName);
        rsMap.put("fileName", fileName);
        this.gen(ids, codeDirPath + File.separator, cuser);
        return rsMap;
    }

    public void genWorkspace(String[] ids, String cuser) throws Exception {
        VariablePo var = this.variableRepository.getByKey("workspace", cuser);
        if (BeanUtils.isEmpty((Object)((Object)var))) {
            throw new Exception("\u672a\u914d\u7f6e\u53d8\u91cf\u3010workspace\u3011");
        }
        String codeDirPath = StringUtil.trimSuffix((String)var.getValue(), (String)File.separator) + File.separator;
        this.gen(ids, codeDirPath, cuser);
    }

    public Map<String, String> deploy(String[] ids, String cuser) throws Exception {
        HashMap<String, String> rsMap = new HashMap<String, String>();
        String fileName = "codegen_" + System.currentTimeMillis();
        String codeDirPath = StringUtil.trimSuffix((String)AppFileUtil.ATTACH_PATH, (String)File.separator) + File.separator + "codegen" + File.separator + fileName;
        rsMap.put("filePath", "codegen" + File.separator + fileName);
        rsMap.put("fileName", fileName);
        this.gen(ids, codeDirPath + File.separator, cuser);
        this.deploy(codeDirPath);
        return rsMap;
    }

    public void copy(String[] ids, String cuser) {
        if (BeanUtils.isEmpty((Object)ids)) {
            return;
        }
        for (String id : ids) {
            SchemePo scheme = this.schemeRepository.loadCascade(id);
            scheme.setId(null);
            scheme.setCreator(cuser);
            scheme.setCreateTime(new Date());
            scheme.setName(scheme.getName() + "_\u590d\u5236_" + DateUtil.getCurrentTime());
            this.setData((PO)scheme);
            this.saveCascade();
        }
    }

    private void gen(String[] ids, String codeDirPath, String cuser) throws Exception {
        File codeDir = new File(codeDirPath);
        if (!codeDir.exists() || codeDir.exists() && !codeDir.isDirectory()) {
            codeDir.mkdirs();
        }
        for (String id : ids) {
            SchemePo scheme = this.schemeRepository.loadCascade(id);
            TableModel tableModel = this.tableModelService.getByTableName(scheme.getTableName());
            if (BeanUtils.isEmpty((Object)tableModel)) {
                throw new Exception("\u8868\u914d\u7f6e\u3010" + scheme.getTableName() + "\u3011\u4e0d\u5b58\u5728");
            }
            this.setVars(tableModel, scheme);
            List<TemplatePo> templates = this.getTemplates(scheme);
            this.genCode(codeDirPath, tableModel, templates, scheme.getGenSub(), "Y".equals(scheme.getIsBase()), scheme.getFormIdentity(), cuser);
        }
    }

    private void deploy(String codeDirPath) {
        String webRootPath = FileUtil.getWebRootPath();
        String classesPath = FileUtil.getClassesPath();
        this.javaCompiler(codeDirPath, webRootPath, classesPath);
        this.copyMapper(codeDirPath, classesPath);
        this.copyJsp(codeDirPath, webRootPath);
        this.copyJs(codeDirPath, webRootPath);
    }

    private void javaCompiler(String codeDirPath, String webRootPath, String classesPath) {
        String classpath = FileUtil.getJarFiles((String)webRootPath);
        String[] ops = new String[]{"-encoding", "UTF-8", "-classpath", classpath, "-d", classesPath};
        List javaFiles = FileUtil.list((String)codeDirPath, (String)".java");
        ClassUtil.javac((String[])ops, (File[])FileUtil.list2Array((List)javaFiles));
        String basePackage = this.registerBean(classesPath, javaFiles);
        AppUtil.scanBeans((String[])new String[]{basePackage});
    }

    private void copyJs(String codeDirPath, String webRootPath) {
        List jsFiles = FileUtil.list((String)codeDirPath, (String)".js");
        if (BeanUtils.isNotEmpty((Object)jsFiles)) {
            String js1 = "\\js\\";
            String js2 = "/js/";
            String srcFilePath = "";
            String destFilePath = "";
            int idx = 0;
            for (File jsFile : jsFiles) {
                srcFilePath = jsFile.getAbsolutePath();
                idx = srcFilePath.lastIndexOf(js1) > 0 ? srcFilePath.lastIndexOf(js1) : srcFilePath.lastIndexOf(js2);
                destFilePath = webRootPath + File.separator + srcFilePath.substring(idx);
                destFilePath = destFilePath.replaceAll("[\\\\]", "/");
                FileUtil.copyFile((String)srcFilePath, (String)destFilePath, (boolean)true);
            }
        }
    }

    private void copyJsp(String codeDirPath, String webRootPath) {
        List jspFiles = FileUtil.list((String)codeDirPath, (String)".jsp");
        if (BeanUtils.isNotEmpty((Object)jspFiles)) {
            String webInf = "WEB-INF";
            String srcFilePath = "";
            String destFilePath = "";
            for (File jspFile : jspFiles) {
                srcFilePath = jspFile.getAbsolutePath();
                destFilePath = webRootPath + File.separator + srcFilePath.substring(srcFilePath.lastIndexOf(webInf));
                destFilePath = destFilePath.replaceAll("[\\\\]", "/");
                FileUtil.copyFile((String)srcFilePath, (String)destFilePath, (boolean)true);
            }
        }
    }

    private void copyMapper(String codeDirPath, String classesPath) {
        List mapFiles = FileUtil.list((String)codeDirPath, (String)".map.xml");
        if (BeanUtils.isNotEmpty((Object)mapFiles)) {
            String resources1 = "\\resources\\";
            String resources2 = "/resources/";
            String srcFilePath = "";
            String destFilePath = "";
            int idx = 0;
            int len = 0;
            for (File mapFile : mapFiles) {
                srcFilePath = mapFile.getAbsolutePath();
                idx = srcFilePath.lastIndexOf(resources1) > 0 ? srcFilePath.lastIndexOf(resources1) : srcFilePath.lastIndexOf(resources1);
                len = srcFilePath.lastIndexOf(resources1) > 0 ? resources1.length() : resources2.length();
                destFilePath = classesPath + File.separator + srcFilePath.substring(idx + len);
                destFilePath = destFilePath.replaceAll("[\\\\]", "/");
                FileUtil.copyFile((String)srcFilePath, (String)destFilePath, (boolean)true);
            }
        }
        this.registerMapper(classesPath, mapFiles);
    }

    private String registerBean(String classesPath, List<File> javaFiles) {
        String basePackage = "";
        if (BeanUtils.isNotEmpty(javaFiles)) {
            Class cls = null;
            for (File javaFile : javaFiles) {
                String classFileName = javaFile.getName().replaceAll(".java", ".class");
                List classFiles = FileUtil.list((String)classesPath, (String)classFileName);
                if (BeanUtils.isEmpty((Object)classFiles)) continue;
                String className = ClassUtil.getFullyQualifiedName2((String)((File)classFiles.get(0)).getAbsolutePath());
                try {
                    IbpsClassLoader loader = new IbpsClassLoader(classesPath);
                    cls = loader.loadClass(className, true);
                    if (BeanUtils.isEmpty((Object)cls)) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Load class {} {}.", (Object)className, (Object)"failure");
                        continue;
                    }
                    basePackage = StringUtil.isEmpty((CharSequence)basePackage) ? cls.getPackage().getName() : this.getBasePackage(basePackage, cls.getPackage().getName());
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("basePackage ---> {}", (Object)basePackage);
                }
                catch (ClassNotFoundException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(e.getMessage());
                }
            }
        }
        return StringUtil.isEmpty((CharSequence)basePackage) ? "com.lc.ibps" : basePackage;
    }

    public String getBasePackage(String s1, String s2) {
        String max = s1.length() > s2.length() ? s1 : s2;
        String min = max.equals(s1) ? s2 : s1;
        for (int x = 0; x < min.length(); ++x) {
            int y = 0;
            for (int z = min.length() - x; z != min.length() + 1; ++z) {
                String temp = min.substring(y, z);
                if (max.contains(temp)) {
                    return temp;
                }
                ++y;
            }
        }
        return "com.lc.ibps";
    }

    private void registerMapper(String classesPath, List<File> mapFiles) {
        if (BeanUtils.isNotEmpty(mapFiles)) {
            MybatisSqlSessionFactoryBean sqlSessionFactory = (MybatisSqlSessionFactoryBean)AppUtil.getBean(MybatisSqlSessionFactoryBean.class);
            String resources1 = "\\resources\\";
            String resources2 = "/resources/";
            String srcFilePath = "";
            String destFilePath = "";
            int idx = 0;
            int len = 0;
            for (File mapFile : mapFiles) {
                srcFilePath = mapFile.getAbsolutePath();
                idx = srcFilePath.lastIndexOf(resources1) > 0 ? srcFilePath.lastIndexOf(resources1) : srcFilePath.lastIndexOf(resources1);
                len = srcFilePath.lastIndexOf(resources1) > 0 ? resources1.length() : resources2.length();
                destFilePath = "classpath*:" + srcFilePath.substring(idx + len);
                try {
                    sqlSessionFactory.loadMapping(new String[]{destFilePath});
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("load mapping for {} failure. msg={}", (Object)destFilePath, (Object)e.getMessage());
                }
            }
        }
    }

    private void setVars(TableModel tableModel, SchemePo scheme) {
        Map<String, String> varMap = this.getVarMap(scheme);
        tableModel.getVariables().putAll(varMap);
        if (BeanUtils.isNotEmpty((Object)tableModel.getSubTableList())) {
            List subTableModelList = tableModel.getSubTableList();
            for (TableModel subTableModel : subTableModelList) {
                subTableModel.getVariables().putAll(varMap);
            }
        }
    }

    private void genCode(String codeDirPath, TableModel tableModel, List<TemplatePo> templates, String genSub, boolean isBaseModule, String formIdentity, String cuser) throws Exception {
        this.getJspContent(tableModel, formIdentity);
        TemplatePo functionTemplatePo = this.templateRepository.getByTKey("function");
        TemplatePo variableTemplatePo = this.templateRepository.getByTKey("variable");
        String sysValue = (String)tableModel.getVariables().get("sys");
        String appValue = (String)tableModel.getVariables().get("app");
        VariablePo appKeysVar = this.variableRepository.getByKey("appKeys", cuser);
        VariablePo apiKeysVar = this.variableRepository.getByKey("apiKeys", cuser);
        VariablePo consumerKeysVar = this.variableRepository.getByKey("consumerKeys", cuser);
        VariablePo providerKeysVar = this.variableRepository.getByKey("providerKeys", cuser);
        VariablePo modelKeysVar = this.variableRepository.getByKey("modelKeys", cuser);
        VariablePo bizKeysVar = this.variableRepository.getByKey("bizKeys", cuser);
        VariablePo apiPathVar = this.variableRepository.getByKey(sysValue + "ApiPath", cuser);
        VariablePo consumerPathVar = this.variableRepository.getByKey(sysValue + "ConsumerPath", cuser);
        VariablePo providerPathVar = this.variableRepository.getByKey(sysValue + "ProviderPath", cuser);
        VariablePo modelPathVar = this.variableRepository.getByKey(sysValue + "ModelPath", cuser);
        VariablePo sysPathVar = this.variableRepository.getByKey(sysValue + "Path", cuser);
        VariablePo appPathVar = this.variableRepository.getByKey(appValue + "Path", cuser);
        String fileName = null;
        String filePath = null;
        StringBuilder templateSource = new StringBuilder();
        for (TemplatePo templatePo : templates) {
            templateSource.setLength(0);
            templateSource.append(functionTemplatePo.getContent());
            templateSource.append(variableTemplatePo.getContent());
            templateSource.append(templatePo.getContent());
            filePath = codeDirPath;
            if (this.containsTemplate(apiKeysVar.getValue(), templatePo.getKey())) {
                if (BeanUtils.isEmpty((Object)((Object)apiPathVar))) {
                    throw new Exception("\u672a\u914d\u7f6e\u53d8\u91cf\u3010" + sysValue + "ApiPath\u3011");
                }
                filePath = filePath + apiPathVar.getValue();
            } else if (this.containsTemplate(consumerKeysVar.getValue(), templatePo.getKey())) {
                if (BeanUtils.isEmpty((Object)((Object)consumerPathVar))) {
                    throw new Exception("\u672a\u914d\u7f6e\u53d8\u91cf\u3010" + sysValue + "ConsumerPath\u3011");
                }
                filePath = filePath + consumerPathVar.getValue();
            } else if (this.containsTemplate(providerKeysVar.getValue(), templatePo.getKey())) {
                if (BeanUtils.isEmpty((Object)((Object)providerPathVar))) {
                    throw new Exception("\u672a\u914d\u7f6e\u53d8\u91cf\u3010" + sysValue + "ProviderPath\u3011");
                }
                filePath = filePath + providerPathVar.getValue();
            } else if (this.containsTemplate(modelKeysVar.getValue(), templatePo.getKey())) {
                if (BeanUtils.isEmpty((Object)((Object)modelPathVar))) {
                    throw new Exception("\u672a\u914d\u7f6e\u53d8\u91cf\u3010" + sysValue + "ModelPath\u3011");
                }
                filePath = filePath + modelPathVar.getValue();
            } else if (this.containsTemplate(bizKeysVar.getValue(), templatePo.getKey())) {
                if (BeanUtils.isEmpty((Object)((Object)sysPathVar))) {
                    throw new Exception("\u672a\u914d\u7f6e\u53d8\u91cf\u3010" + sysValue + "Path\u3011");
                }
                filePath = filePath + sysPathVar.getValue();
            } else if (this.containsTemplate(appKeysVar.getValue(), templatePo.getKey())) {
                if (BeanUtils.isEmpty((Object)((Object)appPathVar))) {
                    throw new Exception("\u672a\u914d\u7f6e\u53d8\u91cf\u3010" + appValue + "Path\u3011");
                }
                filePath = filePath + appPathVar.getValue();
            } else {
                throw new Exception("\u6a21\u677f\u6240\u5728DoType\u672a\u6dfb\u52a0\u5230\u53d8\u91cfapiKeys/consumerKeys/modeKeys/bizKeys/appKeys\u4e2d\uff01");
            }
            fileName = StringUtil.trimSuffix((String)filePath, (String)File.separator) + File.separator + StringUtil.trimSuffix((String)templatePo.getDir(), (String)File.separator) + File.separator + templatePo.getFilename();
            if (!(!isBaseModule || "mapping".equalsIgnoreCase(templatePo.getKey()) || "controller".equalsIgnoreCase(templatePo.getKey()) || "tree".equalsIgnoreCase(templatePo.getKey()) || "list".equalsIgnoreCase(templatePo.getKey()) || "edit".equalsIgnoreCase(templatePo.getKey()) || "flowEdit".equalsIgnoreCase(templatePo.getKey()) || "get".equalsIgnoreCase(templatePo.getKey()) || "web".equalsIgnoreCase(templatePo.getKey()))) {
                fileName = fileName.replace("{module}\\", "");
                fileName = fileName.replace("{module}", "");
            }
            fileName = StringUtil.replaceVariable((String)fileName, (Map)tableModel.getVariables());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("model", tableModel);
            map.put("vars", tableModel.getVariables());
            map.put("date", new Date());
            String resultContent = this.freemarkerEngine.parseByStringTemplate(templateSource.toString(), map);
            FileUtil.writeFile((String)fileName, (String)resultContent.trim());
        }
        List subTableModelList = tableModel.getSubTableList();
        if ("Y".equalsIgnoreCase(genSub) && BeanUtils.isNotEmpty((Object)subTableModelList)) {
            ArrayList<String> keys = new ArrayList<String>();
            this.grep(templates, keys);
            for (TableModel subTableModel : subTableModelList) {
                subTableModel.getVariables().put("layerTemplate", tableModel.getLayerTemplate());
                this.genCode(codeDirPath, subTableModel, templates, "N", isBaseModule, formIdentity, cuser);
            }
        }
    }

    private void getJspContent(TableModel tableModel, String formIdentity) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String getContent = null;
        String editContent = null;
        String tableName = tableModel.getTableName();
        boolean isSub = tableModel.getSub();
        params.put("tableModel", tableModel);
        this.formbuilderStrategy = (IFormbuilderStrategy)AppUtil.getBean((String)(FormMode.CODE_GEN.key() + "FormbuilderStrategy"));
        String code = null;
        String subCode = null;
        if (isSub) {
            subCode = tableName;
        } else {
            code = tableName;
        }
        String data = this.formbuilderStrategy.getData(code, subCode, formIdentity);
        if (JsonUtil.isJsonObject((Object)data) && JsonUtil.isEmpty((Object)JSONObject.fromObject((Object)data))) {
            data = this.formbuilderStrategy.getData(subCode, null, null);
        }
        TableModelBuilder.build(tableModel, JSONObject.fromObject((Object)data));
        editContent = this.formbuilderStrategy.buildFormTemplate(data, params);
        params.put("genView", "formGet");
        getContent = this.formbuilderStrategy.buildFormTemplate(data, params);
        if (StringUtil.isEmpty((CharSequence)getContent)) {
            throw new Exception("\u8868\u914d\u7f6e\u3010" + tableName + "\u3011\u8f6c\u6362\u9519\u8bef\uff0cedit\u9875\u9762\u4e3a\u7a7a\uff01");
        }
        tableModel.getVariables().put("getContent", getContent);
        if (StringUtil.isEmpty((CharSequence)editContent)) {
            throw new Exception("\u8868\u914d\u7f6e\u3010" + tableName + "\u3011\u8f6c\u6362\u9519\u8bef\uff0cedit\u9875\u9762\u4e3a\u7a7a\uff01");
        }
        tableModel.getVariables().put("editContent", editContent);
    }

    private boolean containsTemplate(String keys, String templateKey) {
        String[] doKeyArr = keys.split(",");
        DoTypePo doTypePo = null;
        for (String key : doKeyArr) {
            doTypePo = this.doTypeRepository.getByDoKey(key);
            if (!"template".equalsIgnoreCase(doTypePo.getSubType()) || !doTypePo.getSubKeys().contains(templateKey)) continue;
            return true;
        }
        return false;
    }

    private void grep(List<TemplatePo> templates, List<String> keys) {
        Iterator<TemplatePo> ite = templates.iterator();
        while (ite.hasNext()) {
            TemplatePo po = ite.next();
            if (!keys.contains(po.getKey())) continue;
            ite.remove();
        }
    }

    private List<TemplatePo> getTemplates(SchemePo scheme) {
        String[] doKeyArr = scheme.getDoType().split(",");
        ArrayList<TemplatePo> templates = new ArrayList<TemplatePo>();
        List<TemplatePo> _templates = null;
        DoTypePo doTypePo = null;
        DoTypePo _doTypePo = null;
        for (String key : doKeyArr) {
            doTypePo = this.doTypeRepository.getByDoKey(key);
            if ("doType".equalsIgnoreCase(doTypePo.getSubType())) {
                String[] doTypeArr;
                for (String doTypeKey : doTypeArr = doTypePo.getSubKeys().split(",")) {
                    _doTypePo = this.doTypeRepository.getByDoKey(doTypeKey);
                    _templates = this.templateRepository.findByKeys(_doTypePo.getSubKeys().split(","));
                    if (!BeanUtils.isNotEmpty(_templates)) continue;
                    templates.removeAll(_templates);
                    templates.addAll(_templates);
                }
                break;
            }
            _templates = this.templateRepository.findByKeys(doTypePo.getSubKeys().split(","));
            if (!BeanUtils.isNotEmpty(_templates)) continue;
            templates.removeAll(_templates);
            templates.addAll(_templates);
        }
        return templates;
    }

    private Map<String, String> getVarMap(SchemePo scheme) {
        List<SchemeParamPo> spList;
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("sys", scheme.getSys());
        varMap.put("app", scheme.getPlatform());
        varMap.put("module", scheme.getModule());
        varMap.put("baseClass", StringUtil.upperFirst((String)scheme.getModule()));
        varMap.put("isBaseModule", "Y".equalsIgnoreCase(scheme.getIsBase()) ? "true" : "false");
        varMap.put("isGenSub", "Y".equalsIgnoreCase(scheme.getGenSub()) ? "true" : "false");
        varMap.put("developer", scheme.getDeveloper());
        varMap.put("email", scheme.getEmail());
        List<VariablePo> vars = this.variableRepository.findByType("global");
        if (BeanUtils.isNotEmpty(vars)) {
            for (VariablePo var : vars) {
                varMap.put(var.getKey(), var.getValue());
            }
        }
        if (BeanUtils.isNotEmpty(spList = scheme.getSchemeParamPoList())) {
            for (SchemeParamPo sp : spList) {
                varMap.put(sp.getKey(), sp.getValue());
            }
        }
        return varMap;
    }
}

