/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.codegen.domain;

import com.lc.ibps.base.core.util.AppUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.Dom4jUtil;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.base.framework.domain.AbstractDomain;
import com.lc.ibps.components.codegen.persistence.dao.TemplateDao;
import com.lc.ibps.components.codegen.persistence.dao.TemplateQueryDao;
import com.lc.ibps.components.codegen.persistence.entity.TemplatePo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class Template
extends AbstractDomain<String, TemplatePo> {
    private static final String PATH = "/template/codegen/";
    private static final String CODEGEN_XML_PATH = "/template/codegen/codegen.xml";
    private TemplateDao templateDao = null;
    private TemplateQueryDao templateQueryDao = null;

    protected void init() {
        this.templateDao = (TemplateDao)AppUtil.getBean(TemplateDao.class);
        this.templateQueryDao = (TemplateQueryDao)AppUtil.getBean(TemplateQueryDao.class);
        this.setDao(this.templateDao);
    }

    public void initTemplate(String creator) throws URISyntaxException, IOException {
        this.templateDao.removeAll();
        this.initTpl(creator, AppUtil.getSysTenantId());
    }

    public void initTpl(String creator, String tenantId) throws URISyntaxException, IOException {
        String baseUrl = Template.class.getResource("/").toURI().getPath();
        Document doc = Dom4jUtil.load((String)(baseUrl + File.separator + CODEGEN_XML_PATH));
        this.initTemplate(baseUrl, doc, creator, tenantId);
    }

    private void initTemplate(String baseUrl, Document doc, String creator, String tenantId) throws IOException {
        Element root = doc.getRootElement();
        Element templates = root.element("templates");
        Element files = (Element)root.selectSingleNode("files[@isDefault='true']");
        if (BeanUtils.isEmpty((Object)files)) {
            throw new IOException("\u6ca1\u6709\u627e\u5230[isDefault=\"true\"]\u7684\u8282\u70b9[files]!");
        }
        List fileList = files.elements();
        for (Element file : fileList) {
            this.create(baseUrl, creator, tenantId, templates, file);
        }
    }

    private BufferedReader create(String baseUrl, String creator, String tenantId, Element templates, Element file) throws IOException {
        BufferedReader bufferedReader = null;
        StringBuilder templateContent = new StringBuilder();
        templateContent.setLength(0);
        String refTemplate = file.attributeValue("refTemplate");
        String filename = file.attributeValue("filename");
        String dir = file.attributeValue("dir");
        String sub = StringUtil.isEmpty((CharSequence)file.attributeValue("sub")) ? "true" : file.attributeValue("sub");
        String override = StringUtil.isEmpty((CharSequence)file.attributeValue("override")) ? "true" : file.attributeValue("override");
        Element template = (Element)templates.selectSingleNode("template[@key='" + refTemplate + "']");
        String templatePath = template.attributeValue("path");
        try {
            String line;
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(baseUrl + PATH + templatePath), "UTF-8");
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                templateContent.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (BeanUtils.isNotEmpty(bufferedReader)) {
                bufferedReader.close();
            }
        }
        TemplatePo po = new TemplatePo();
        po.setKey(refTemplate);
        po.setName(refTemplate);
        po.setFilename(filename);
        po.setDir(dir);
        po.setSub(sub);
        po.setOverride(override);
        po.setPath(PATH + templatePath);
        po.setCreator(creator);
        po.setIsDef("Y");
        po.setCreateTime(new Date());
        po.setContent(templateContent.toString());
        po.setTenantId(tenantId);
        this.templateDao.create((Object)po);
        return bufferedReader;
    }

    public void updateType(String typeId, List<String> templateIds) {
        if (BeanUtils.isEmpty(templateIds)) {
            return;
        }
        TemplatePo po = null;
        for (String id : templateIds) {
            po = (TemplatePo)((Object)this.templateQueryDao.get(id));
            po.setTypeId(typeId);
            this.templateDao.update((Object)po);
        }
    }
}

