/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.codegen.repository.impl;

import com.lc.ibps.api.base.query.QueryFilter;
import com.lc.ibps.api.base.query.QueryOP;
import com.lc.ibps.base.core.util.AppUtil;
import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.base.db.model.DefaultQueryFilter;
import com.lc.ibps.base.framework.persistence.dao.IQueryDao;
import com.lc.ibps.base.framework.persistence.entity.PO;
import com.lc.ibps.base.framework.repository.AbstractRepository;
import com.lc.ibps.components.codegen.domain.TableConfig;
import com.lc.ibps.components.codegen.persistence.dao.FieldConfigQueryDao;
import com.lc.ibps.components.codegen.persistence.dao.TableConfigQueryDao;
import com.lc.ibps.components.codegen.persistence.entity.FieldConfigPo;
import com.lc.ibps.components.codegen.persistence.entity.TableConfigPo;
import com.lc.ibps.components.codegen.repository.TableConfigRepository;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository
public class TableConfigRepositoryImpl
extends AbstractRepository<String, TableConfigPo, TableConfig>
implements TableConfigRepository {
    @Resource
    private TableConfigQueryDao tableConfigQueryDao;
    @Resource
    private FieldConfigQueryDao fieldConfigQueryDao;

    public TableConfig newInstance() {
        TableConfigPo po = new TableConfigPo();
        TableConfig tableConfig = (TableConfig)((Object)AppUtil.getBean(TableConfig.class));
        tableConfig.setData((PO)po);
        return tableConfig;
    }

    public TableConfig newInstance(TableConfigPo po) {
        TableConfig tableConfig = (TableConfig)((Object)AppUtil.getBean(TableConfig.class));
        tableConfig.setData((PO)po);
        return tableConfig;
    }

    protected IQueryDao<String, TableConfigPo> getQueryDao() {
        return this.tableConfigQueryDao;
    }

    @Override
    public boolean exsitTableConfig(String id, String tableName) {
        DefaultQueryFilter queryFilter = new DefaultQueryFilter();
        queryFilter.setPage(null);
        queryFilter.addFilter("ID_", (Object)id, QueryOP.NOT_EQUAL);
        queryFilter.addFilter("TABLE_NAME_", (Object)tableName, QueryOP.EQUAL);
        List list = this.tableConfigQueryDao.queryByQueryFilter("query", (QueryFilter)queryFilter);
        return BeanUtils.isNotEmpty((Object)list);
    }

    @Override
    public TableConfigPo loadCascade(String id) {
        TableConfigPo tableConfigPo = null;
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            tableConfigPo = (TableConfigPo)((Object)this.tableConfigQueryDao.get(id));
            List<FieldConfigPo> fieldConfigPoList = this.fieldConfigQueryDao.findByMainId(id);
            tableConfigPo.setFieldConfigPoList(fieldConfigPoList);
        }
        return tableConfigPo;
    }

    @Override
    public TableConfigPo loadCascadeByTableName(String tableName) {
        return this.loadCascadeByTableName(tableName, true);
    }

    @Override
    public TableConfigPo loadCascadeByBoId(String boId) {
        return this.loadCascadeByBoId(boId, true);
    }

    @Override
    public TableConfigPo loadCascadeByTableName(String tableName, boolean throwException) {
        TableConfigPo tableConfigPo = null;
        if (StringUtil.isNotEmpty((CharSequence)tableName)) {
            tableConfigPo = this.tableConfigQueryDao.getByTableName(tableName);
            if (BeanUtils.isEmpty((Object)((Object)tableConfigPo)) && throwException) {
                throw new RuntimeException("\u8868\u914d\u7f6e\u88ab\u5220\u9664");
            }
            if (BeanUtils.isEmpty((Object)((Object)tableConfigPo)) && !throwException) {
                return null;
            }
            List<FieldConfigPo> fieldConfigPoList = this.fieldConfigQueryDao.findByMainId(tableConfigPo.getId());
            tableConfigPo.setFieldConfigPoList(fieldConfigPoList);
        }
        return tableConfigPo;
    }

    @Override
    public TableConfigPo loadCascadeByBoId(String boId, boolean throwException) {
        TableConfigPo tableConfigPo = null;
        if (StringUtil.isNotEmpty((CharSequence)boId)) {
            tableConfigPo = this.tableConfigQueryDao.getByBoId(boId);
            if (BeanUtils.isEmpty((Object)((Object)tableConfigPo)) && throwException) {
                throw new RuntimeException("\u8868\u914d\u7f6e\u88ab\u5220\u9664");
            }
            if (BeanUtils.isEmpty((Object)((Object)tableConfigPo)) && !throwException) {
                return null;
            }
            List<FieldConfigPo> fieldConfigPoList = this.fieldConfigQueryDao.findByMainId(tableConfigPo.getId());
            tableConfigPo.setFieldConfigPoList(fieldConfigPoList);
        }
        return tableConfigPo;
    }

    @Override
    public List<TableConfigPo> findByPTableName(String tableName) {
        return this.tableConfigQueryDao.findByPTableName(tableName);
    }

    @Override
    public TableConfigPo getByTableName(String tableName) {
        return this.tableConfigQueryDao.getByTableName(tableName);
    }

    @Override
    public TableConfigPo getByBoId(String boId) {
        return this.tableConfigQueryDao.getByBoId(boId);
    }
}

