/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.codegen.service;

import com.lc.ibps.base.core.util.BeanUtils;
import com.lc.ibps.base.core.util.string.StringUtil;
import com.lc.ibps.components.codegen.builder.TableModelBuilder;
import com.lc.ibps.components.codegen.model.TableModel;
import com.lc.ibps.components.codegen.persistence.entity.FieldConfigPo;
import com.lc.ibps.components.codegen.persistence.entity.TableConfigPo;
import com.lc.ibps.components.codegen.persistence.entity.VariablePo;
import com.lc.ibps.components.codegen.repository.FieldConfigRepository;
import com.lc.ibps.components.codegen.repository.TableConfigRepository;
import com.lc.ibps.components.codegen.repository.VariableRepository;
import com.lc.ibps.components.codegen.service.ITableModelService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="tableModelService")
public class DefaultTableModelService
implements ITableModelService {
    @Resource
    private TableConfigRepository tableConfigRepository;
    @Resource
    private FieldConfigRepository fieldConfigRepository;
    @Resource
    private VariableRepository variableRepository;

    public TableModel getByTableName(String tableName) {
        TableConfigPo tableConfig = this.tableConfigRepository.loadCascadeByTableName(tableName);
        return this.getTableModel(tableConfig);
    }

    private TableModel getTableModel(TableConfigPo tableConfig) {
        if (BeanUtils.isEmpty((Object)((Object)tableConfig))) {
            return null;
        }
        TableModel tableModel = TableModelBuilder.build(tableConfig);
        Map<String, String> varMap = this.getVarMap(tableConfig);
        tableModel.setVariables(varMap);
        this.getSubTableModel(varMap, tableModel);
        return tableModel;
    }

    private void getSubTableModel(Map<String, String> varMap, TableModel tableModel) {
        HashMap<String, String> subVarMap = null;
        List<TableConfigPo> subTableConfigList = this.tableConfigRepository.findByPTableName(tableModel.getTableName());
        if (BeanUtils.isNotEmpty(subTableConfigList)) {
            TableModel subTableModel = null;
            for (TableConfigPo subTableConfig : subTableConfigList) {
                subVarMap = new HashMap<String, String>();
                subVarMap.putAll(varMap);
                subVarMap.put("class", subTableConfig.getClassName());
                subVarMap.put("classVar", StringUtil.lowerFirst((String)subTableConfig.getClassName()));
                List<FieldConfigPo> fieldConfigList = this.fieldConfigRepository.findByMainId(subTableConfig.getId());
                subTableConfig.setFieldConfigPoList(fieldConfigList);
                subTableModel = TableModelBuilder.build(subTableConfig);
                subTableModel.setVariables(subVarMap);
                tableModel.getSubTableList().add(subTableModel);
            }
        }
    }

    private Map<String, String> getVarMap(TableConfigPo tableConfig) {
        List<VariablePo> vars;
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("class", tableConfig.getClassName());
        varMap.put("classVar", StringUtil.lowerFirst((String)tableConfig.getClassName()));
        varMap.put("struType", tableConfig.getStruType());
        varMap.put("idKey", tableConfig.getIdKey());
        varMap.put("pidKey", tableConfig.getPidKey());
        varMap.put("key", tableConfig.getKey());
        if (StringUtil.isNotBlank((CharSequence)tableConfig.getDsAlias())) {
            varMap.put("dsAlias", tableConfig.getDsAlias());
        }
        if (BeanUtils.isNotEmpty(vars = this.variableRepository.findByType("global"))) {
            for (VariablePo var : vars) {
                varMap.put(var.getKey(), var.getValue());
            }
        }
        return varMap;
    }

    public TableModel getByBoId(String boId) {
        TableConfigPo tableConfig = this.tableConfigRepository.loadCascadeByBoId(boId);
        return this.getTableModel(tableConfig);
    }

    public TableModel getByBoId(String boId, boolean throwException) {
        TableConfigPo tableConfig = this.tableConfigRepository.loadCascadeByBoId(boId, throwException);
        return this.getTableModel(tableConfig);
    }
}

