/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.quartz.impl;

import com.lc.ibps.base.core.entity.ResultMessage;
import com.lc.ibps.base.core.util.time.DateFormatUtil;
import com.lc.ibps.components.quartz.ISchedulerPersistence;
import com.lc.ibps.components.quartz.model.PlanObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public class SchedulerPersistenceImpl
implements ISchedulerPersistence {
    Scheduler scheduler;
    private static HashMap<String, String> mapWeek = new HashMap();

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public ResultMessage addJob(String jobName, String className, String schedGroup, Map<String, Object> parameterMap, String description) throws SchedulerException {
        if (this.scheduler == null) {
            return new ResultMessage(0, "scheduler \u6ca1\u6709\u914d\u7f6e!");
        }
        boolean isJobExist = this.isJobExists(jobName, schedGroup);
        if (isJobExist) {
            return new ResultMessage(0, "\u4efb\u52a1\u5df2\u5b58\u5728");
        }
        ResultMessage resultMsg = null;
        try {
            Class<?> clazz = Class.forName(className);
            JobBuilder jb = JobBuilder.newJob(clazz);
            jb.withIdentity(jobName, schedGroup);
            if (parameterMap != null) {
                JobDataMap map = new JobDataMap();
                map.putAll(parameterMap);
                jb.usingJobData(map);
            }
            jb.storeDurably();
            jb.withDescription(description);
            JobDetail jobDetail = jb.build();
            this.scheduler.addJob(jobDetail, true);
            resultMsg = new ResultMessage(1, "\u6dfb\u52a0\u4efb\u52a1\u6210\u529f!");
            return resultMsg;
        }
        catch (ClassNotFoundException e) {
            throw new SchedulerException(className + ",\u6307\u5b9a\u7684\u4efb\u52a1\u7c7b\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u5b9e\u73b0BaseJob");
        }
        catch (Exception e) {
            resultMsg = new ResultMessage(0, e.getMessage());
            return resultMsg;
        }
    }

    public void delJob(String jobName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        JobKey key = new JobKey(jobName, schedGroup);
        this.scheduler.deleteJob(key);
    }

    public boolean isJobExists(String jobName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return false;
        }
        JobKey key = new JobKey(jobName, schedGroup);
        return this.scheduler.checkExists(key);
    }

    public List<JobDetail> findJobList(String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return new ArrayList<JobDetail>();
        }
        ArrayList<JobDetail> list = new ArrayList<JobDetail>();
        GroupMatcher matcher = null;
        matcher = StringUtils.isNotEmpty((String)schedGroup) ? GroupMatcher.groupEquals((String)schedGroup) : GroupMatcher.anyJobGroup();
        Set set = this.scheduler.getJobKeys(matcher);
        for (JobKey jobKey : set) {
            JobDetail detail = this.scheduler.getJobDetail(jobKey);
            list.add(detail);
        }
        return list;
    }

    public boolean isTriggerExists(String triggerName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return false;
        }
        TriggerKey triggerKey = new TriggerKey(triggerName, schedGroup);
        return this.scheduler.checkExists(triggerKey);
    }

    public void addTrigger(String jobName, String triggerName, String planJson, String schedGroup) throws SchedulerException, ParseException {
        if (this.scheduler == null) {
            return;
        }
        JobKey jobKey = new JobKey(jobName, schedGroup);
        TriggerBuilder tb = TriggerBuilder.newTrigger();
        tb.withIdentity(triggerName, schedGroup);
        this.setTrigBuilder(planJson, (TriggerBuilder<Trigger>)tb);
        tb.forJob(jobKey);
        Trigger trig = tb.build();
        this.scheduler.scheduleJob(trig);
    }

    private void setTrigBuilder(String planJson, TriggerBuilder<Trigger> tb) throws ParseException {
        JSONObject jsonObject = JSONObject.fromObject((Object)planJson);
        PlanObject planObject = (PlanObject)JSONObject.toBean((JSONObject)jsonObject, PlanObject.class);
        int type = planObject.getType();
        String value = planObject.getTimeInterval();
        CronScheduleBuilder sb = null;
        switch (type) {
            case 1: {
                Date date = DateFormatUtil.parseDateTime((String)value);
                tb.startAt(date).withDescription("\u6267\u884c\u4e00\u6b21,\u6267\u884c\u65f6\u95f4:" + DateFormatUtil.format((Object)date));
                break;
            }
            case 2: {
                int minute = Integer.parseInt(value);
                sb = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withIntervalInMinutes(minute);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf:" + minute + "\u5206\u949f\u6267\u884c!");
                break;
            }
            case 3: {
                String[] aryTime = value.split(":");
                int hour = Integer.parseInt(aryTime[0]);
                int m = Integer.parseInt(aryTime[1]);
                sb = CronScheduleBuilder.dailyAtHourAndMinute((int)hour, (int)m);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u5929\uff1a" + hour + ":" + m + "\u6267\u884c!");
                break;
            }
            case 4: {
                String[] aryExpression = value.split("[|]");
                String week = aryExpression[0];
                String[] aryTime1 = aryExpression[1].split(":");
                String h1 = aryTime1[0];
                String m1 = aryTime1[1];
                String cronExperssion = "0 " + m1 + " " + h1 + " ? * " + week;
                sb = CronScheduleBuilder.cronSchedule((String)cronExperssion);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u5468\uff1a" + this.getWeek(week) + "," + h1 + ":" + m1 + "\u6267\u884c!");
                break;
            }
            case 5: {
                String[] aryExpression5 = value.split("[|]");
                String day = aryExpression5[0];
                String[] aryTime2 = aryExpression5[1].split(":");
                String h2 = aryTime2[0];
                String m2 = aryTime2[1];
                String cronExperssion1 = "0 " + m2 + " " + h2 + " " + day + " * ?";
                sb = CronScheduleBuilder.cronSchedule((String)cronExperssion1);
                tb.startNow().withSchedule((ScheduleBuilder)sb).withDescription("\u6bcf\u6708:" + this.getDay(day) + "," + h2 + ":" + m2 + "\u6267\u884c!");
                break;
            }
            case 6: {
                sb = CronScheduleBuilder.cronSchedule((String)value);
                tb.startNow().withSchedule((ScheduleBuilder)sb);
                tb.withDescription("CronTrigger\u8868\u8fbe\u5f0f:" + value);
            }
        }
    }

    private String getWeek(String week) {
        String[] aryWeek = week.split(",");
        int len = aryWeek.length;
        String str = "";
        for (int i = 0; i < len; ++i) {
            str = i < len - 1 ? str + mapWeek.get(aryWeek[i]) + "," : str + mapWeek.get(aryWeek[i]);
        }
        return str;
    }

    private String getDay(String day) {
        String[] aryDay = day.split(",");
        int len = aryDay.length;
        String str = "";
        for (int i = 0; i < len; ++i) {
            String tmp = aryDay[i];
            tmp = tmp.equals("L") ? "\u6700\u540e\u4e00\u5929" : tmp + "\u65e5";
            str = i < len - 1 ? str + tmp + "," : str + tmp;
        }
        return str;
    }

    public List<Trigger> findTriggersByJob(String jobName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return new ArrayList<Trigger>();
        }
        JobKey key = new JobKey(jobName, schedGroup);
        return this.scheduler.getTriggersOfJob(key);
    }

    public void delTrigger(String triggerName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        TriggerKey key = new TriggerKey(triggerName, schedGroup);
        this.scheduler.unscheduleJob(key);
    }

    public HashMap<String, Trigger.TriggerState> getTriggerStatus(List<Trigger> list) throws SchedulerException {
        if (this.scheduler == null) {
            return new HashMap<String, Trigger.TriggerState>();
        }
        HashMap<String, Trigger.TriggerState> map = new HashMap<String, Trigger.TriggerState>();
        for (Trigger trigger : list) {
            TriggerKey key = trigger.getKey();
            Trigger.TriggerState state = this.scheduler.getTriggerState(key);
            map.put(key.getName(), state);
        }
        return map;
    }

    static {
        mapWeek.put("MON", "\u661f\u671f\u4e00");
        mapWeek.put("TUE", "\u661f\u671f\u4e8c");
        mapWeek.put("WED", "\u661f\u671f\u4e09");
        mapWeek.put("THU", "\u661f\u671f\u56db");
        mapWeek.put("FRI", "\u661f\u671f\u4e94");
        mapWeek.put("SAT", "\u661f\u671f\u516d");
        mapWeek.put("SUN", "\u661f\u671f\u65e5");
    }
}

