/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.quartz.impl;

import com.lc.ibps.components.quartz.ISchedulerPersistence;
import com.lc.ibps.components.quartz.ISchedulerService;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class SchedulerServiceImpl
implements ISchedulerService {
    Scheduler scheduler;
    @Resource
    ISchedulerPersistence schedulerPersistence;

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void start() throws SchedulerException {
        this.scheduler.start();
    }

    public void shutdown() throws SchedulerException {
        this.scheduler.standby();
    }

    public void executeJob(String jobName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return;
        }
        JobKey key = new JobKey(jobName, schedGroup);
        this.scheduler.triggerJob(key);
    }

    public boolean runTrigger(String triggerName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return false;
        }
        TriggerKey key = new TriggerKey(triggerName, schedGroup);
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (state == Trigger.TriggerState.PAUSED) {
            this.scheduler.resumeTrigger(key);
            return true;
        }
        return state == Trigger.TriggerState.NORMAL;
    }

    public boolean stopTrigger(String triggerName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return false;
        }
        TriggerKey key = new TriggerKey(triggerName, schedGroup);
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (state == Trigger.TriggerState.PAUSED) {
            return true;
        }
        if (state == Trigger.TriggerState.NORMAL) {
            this.scheduler.pauseTrigger(key);
            return true;
        }
        return false;
    }

    public boolean runJob(String jobName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return false;
        }
        List triggersByJob = this.schedulerPersistence.findTriggersByJob(jobName, schedGroup);
        for (Trigger trigger : triggersByJob) {
            boolean runTrigger = this.runTrigger(trigger.getKey().getName(), schedGroup);
            if (runTrigger) continue;
            return false;
        }
        return true;
    }

    public boolean stopJob(String jobName, String schedGroup) throws SchedulerException {
        if (this.scheduler == null) {
            return false;
        }
        List triggersByJob = this.schedulerPersistence.findTriggersByJob(jobName, schedGroup);
        for (Trigger trigger : triggersByJob) {
            boolean stopTrigger = this.stopTrigger(trigger.getKey().getName(), schedGroup);
            if (stopTrigger) continue;
            return false;
        }
        return true;
    }
}

