/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.quartz.service.impl;

import com.lc.ibps.components.quartz.service.AbstractService;
import com.lc.ibps.components.quartz.service.IJobDetailQueryService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;

public class JobDetailQueryServiceImpl
extends AbstractService
implements IJobDetailQueryService {
    public boolean isExists(String jobName, String schedGroup) throws SchedulerException {
        this.verify();
        JobKey key = new JobKey(jobName, schedGroup);
        return this.scheduler.checkExists(key);
    }

    public JobDetail getByJobNameAndGroup(String jobName, String schedGroup) throws SchedulerException {
        this.verify();
        JobKey key = new JobKey(jobName, schedGroup);
        return this.scheduler.getJobDetail(key);
    }

    public List<JobDetail> findByGroup(String schedGroup) throws SchedulerException {
        this.verify();
        ArrayList<JobDetail> list = new ArrayList<JobDetail>();
        GroupMatcher matcher = null;
        matcher = StringUtils.isNotEmpty((String)schedGroup) ? GroupMatcher.jobGroupEquals((String)schedGroup) : GroupMatcher.anyJobGroup();
        Set set = this.scheduler.getJobKeys(matcher);
        for (JobKey jobKey : set) {
            JobDetail detail = this.scheduler.getJobDetail(jobKey);
            list.add(detail);
        }
        return list;
    }

    public List<JobDetail> findByJobNameAndGroup(String jobName, String schedGroup) throws SchedulerException {
        this.verify();
        if (jobName == null) {
            jobName = "";
        }
        List<JobDetail> list = this.findByGroup(schedGroup);
        if ("".equals(jobName)) {
            return list;
        }
        Iterator<JobDetail> iterator = list.iterator();
        while (iterator.hasNext()) {
            JobDetail jobDetail = iterator.next();
            if (jobDetail.getKey().getName().contains(jobName)) continue;
            iterator.remove();
        }
        return list;
    }
}

