/*
 * Decompiled with CFR 0.152.
 */
package com.lc.ibps.components.quartz.service.impl;

import com.lc.ibps.components.quartz.service.AbstractService;
import com.lc.ibps.components.quartz.service.IJobDetailQueryService;
import com.lc.ibps.components.quartz.service.IJobDetailService;
import com.lc.ibps.components.quartz.service.ITriggerQueryService;
import com.lc.ibps.components.quartz.service.ITriggerService;
import java.util.List;
import java.util.Map;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class JobDetailServiceImpl
extends AbstractService
implements IJobDetailService {
    private IJobDetailQueryService jobDetailQueryService;
    private ITriggerService triggerService;
    private ITriggerQueryService triggerQueryService;

    public void setJobDetailQueryService(IJobDetailQueryService jobDetailQueryService) {
        this.jobDetailQueryService = jobDetailQueryService;
    }

    public void setTriggerService(ITriggerService triggerService) {
        this.triggerService = triggerService;
    }

    public void setTriggerQueryService(ITriggerQueryService triggerQueryService) {
        this.triggerQueryService = triggerQueryService;
    }

    public void addJob(String jobName, String className, String schedGroup, Map<String, Object> parameterMap, String description) throws SchedulerException {
        this.verify();
        boolean isJobExist = this.jobDetailQueryService.isExists(jobName, schedGroup);
        if (isJobExist) {
            throw new SchedulerException("\u5b9a\u65f6\u4efb\u52a1\u5df2\u5b58\u5728!");
        }
        try {
            Class<?> clazz = Class.forName(className);
            JobBuilder jb = JobBuilder.newJob(clazz);
            jb.withIdentity(jobName, schedGroup);
            if (parameterMap != null) {
                JobDataMap map = new JobDataMap();
                map.putAll(parameterMap);
                jb.usingJobData(map);
            }
            jb.storeDurably();
            jb.withDescription(description);
            JobDetail jobDetail = jb.build();
            this.scheduler.addJob(jobDetail, true);
        }
        catch (ClassNotFoundException e) {
            throw new SchedulerException(className + ",\u6307\u5b9a\u7684\u4efb\u52a1\u7c7b\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u5b9e\u73b0BaseJob");
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public void delJob(String jobName, String schedGroup) throws SchedulerException {
        this.verify();
        JobKey key = new JobKey(jobName, schedGroup);
        this.scheduler.deleteJob(key);
    }

    public void execute(String jobName, String schedGroup) throws SchedulerException {
        this.verify();
        JobKey key = new JobKey(jobName, schedGroup);
        this.scheduler.triggerJob(key);
    }

    public boolean run(String jobName, String schedGroup) throws SchedulerException {
        this.verify();
        List triggersByJob = this.triggerQueryService.findTriggersByJob(jobName, schedGroup);
        for (Trigger trigger : triggersByJob) {
            boolean runTrigger = this.triggerService.run(trigger.getKey().getName(), schedGroup);
            if (runTrigger) continue;
            return false;
        }
        return true;
    }

    public boolean stop(String jobName, String schedGroup) throws SchedulerException {
        this.verify();
        List triggersByJob = this.triggerQueryService.findTriggersByJob(jobName, schedGroup);
        for (Trigger trigger : triggersByJob) {
            boolean stopTrigger = this.triggerService.stop(trigger.getKey().getName(), schedGroup);
            if (stopTrigger) continue;
            return false;
        }
        return true;
    }
}

